/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.postgres;

import java.sql.SQLException;
import java.util.List;
import org.delia.db.DBErrorConverterBase;
import org.delia.db.DBException;
import org.delia.db.DBValidationException;
import org.delia.db.sql.SqlNameFormatter;
import org.delia.db.sql.table.TableInfo;
import org.delia.error.DeliaError;
import org.h2.jdbc.JdbcSQLIntegrityConstraintViolationException;
import org.postgresql.util.PSQLException;

public class PostgresErrorConverter
extends DBErrorConverterBase {
    private SqlNameFormatter nameFormatter;

    public PostgresErrorConverter(SqlNameFormatter nameFormatter) {
        this.nameFormatter = nameFormatter;
    }

    @Override
    public void convertAndRethrowException(SQLException e) {
        this.printStackTraceIfEnabled(e);
        if (this.isPSQLExceptionWith(e, "duplicate key value violates unique")) {
            throw new DBValidationException(this.makeError("duplicate-unique-value", e));
        }
        if (this.isPSQLExceptionWith(e, "violates foreign key constraint")) {
            throw new DBValidationException(this.makeError("db-validation-fail", e));
        }
        if (e instanceof JdbcSQLIntegrityConstraintViolationException) {
            throw new DBValidationException(this.makeError("db-validation-fail", e));
        }
        if (e instanceof JdbcSQLIntegrityConstraintViolationException) {
            throw new DBValidationException(this.makeError("db-validation-fail", e));
        }
        DeliaError err = new DeliaError("db-unexpected-exception", "UNEXPECTED error: " + e.getMessage());
        throw new DBException(err);
    }

    private DeliaError makeError(String id, Exception e) {
        DeliaError err = new DeliaError(id, e.getMessage());
        return err;
    }

    private boolean isPSQLExceptionWith(SQLException e, String string) {
        return e instanceof PSQLException && e.getMessage().contains(string);
    }

    @Override
    public void convertAndRethrow(DBValidationException e, List<TableInfo> tblinfoL) {
        String msg = e.getMessage();
        if (msg.contains("Unique index or primary key violation")) {
            DeliaError err = new DeliaError("duplicate-unique-value", e.getLastError().getMsg());
            throw new DBValidationException(err);
        }
        if (msg.contains("violates foreign key constraint") || this.isRelationError(msg)) {
            boolean isManyRule = this.findTypeOfViolation(e.getMessage(), tblinfoL);
            String errId = isManyRule ? "rule-relationMany" : "rule-relationOne";
            DeliaError err = new DeliaError(errId, e.getLastError().getMsg());
            throw new DBValidationException(err);
        }
        throw e;
    }

    private boolean isRelationError(String msg) {
        return msg.contains("insert or update on table") && msg.contains("violates foreign key constraint");
    }

    private boolean findTypeOfViolation(String message, List<TableInfo> tblinfoL) {
        for (TableInfo info : tblinfoL) {
            if (info.assocTblName == null || !message.contains(this.nameFormatter.convert(info.assocTblName))) continue;
            return true;
        }
        return false;
    }
}

