/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.postgres;

import org.delia.core.FactoryService;
import org.delia.db.sql.StrCreator;
import org.delia.db.sql.table.FieldGen;
import org.delia.type.DStructType;
import org.delia.type.DTypeRegistry;
import org.delia.type.TypePair;
import org.delia.util.DValueHelper;

public class PostgresFieldGen
extends FieldGen {
    public PostgresFieldGen(FactoryService factorySvc, DTypeRegistry registry, TypePair pair, DStructType dtype) {
        super(factorySvc, registry, pair, dtype);
    }

    @Override
    public void generateField(StrCreator sc) {
        String name = this.pair.name;
        String type = this.deliaToSql(this.pair);
        boolean b = this.dtype.fieldIsUnique(name) || this.dtype.fieldIsPrimaryKey(name);
        String suffix1 = "";
        String suffix1a = "";
        if (this.dtype.fieldIsSerial(name)) {
            suffix1a = " PRIMARY KEY GENERATED ALWAYS AS IDENTITY";
        } else if (b) {
            suffix1 = " UNIQUE";
        }
        String suffix2 = this.dtype.fieldIsOptional(name) ? " NULL" : "";
        sc.o("  %s %s%s%s", name, type, suffix1, suffix1a, suffix2);
    }

    @Override
    public String deliaToSql(TypePair pair) {
        switch (pair.type.getShape()) {
            case INTEGER: {
                return "Int";
            }
            case LONG: {
                return "BIGINT";
            }
            case NUMBER: {
                return "DOUBLE PRECISION";
            }
            case DATE: {
                return "TIMESTAMP";
            }
            case STRING: {
                return "VARCHAR(4096)";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case STRUCT: {
                TypePair innerPair = DValueHelper.findPrimaryKeyFieldPair(pair.type);
                return this.deliaToSql(innerPair);
            }
        }
        return null;
    }
}

