/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.postgres;

import org.delia.core.FactoryService;
import org.delia.db.DBAccessContext;
import org.delia.db.DBErrorConverter;
import org.delia.db.h2.SqlHelperFactory;
import org.delia.db.postgres.PostgresErrorConverter;
import org.delia.db.postgres.PostgresFieldgenFactory;
import org.delia.db.postgres.PostgresInsertStatementGenerator;
import org.delia.db.postgres.PostgresPreparedStatementGenerator;
import org.delia.db.postgres.PostgresSelectFuncHelper;
import org.delia.db.postgres.PostgresTableCreator;
import org.delia.db.postgres.PostgresWhereClauseGenerator;
import org.delia.db.sql.SimpleSqlNameFormatter;
import org.delia.db.sql.SqlNameFormatter;
import org.delia.db.sql.prepared.InsertStatementGenerator;
import org.delia.db.sql.prepared.PreparedStatementGenerator;
import org.delia.db.sql.prepared.SelectFuncHelper;
import org.delia.db.sql.prepared.WhereClauseGenerator;
import org.delia.db.sql.table.FieldGenFactory;
import org.delia.db.sql.table.TableCreator;

public class PostgresSqlHelperFactory
extends SqlHelperFactory {
    public PostgresSqlHelperFactory(FactoryService factorySvc) {
        super(factorySvc);
    }

    @Override
    public FieldGenFactory createFieldGenFactory() {
        return new PostgresFieldgenFactory(this.factorySvc);
    }

    @Override
    public SqlNameFormatter createNameFormatter(DBAccessContext dbctx) {
        SimpleSqlNameFormatter nameFormatter = new SimpleSqlNameFormatter(true);
        return nameFormatter;
    }

    @Override
    public DBErrorConverter createErrorConverter() {
        return new PostgresErrorConverter(this.createNameFormatter(null));
    }

    @Override
    public WhereClauseGenerator createPWhereGen(DBAccessContext dbctx) {
        return new PostgresWhereClauseGenerator(this.factorySvc, dbctx.registry, dbctx.varEvaluator);
    }

    @Override
    public PreparedStatementGenerator createPrepSqlGen(DBAccessContext dbctx) {
        PostgresPreparedStatementGenerator sqlgen = new PostgresPreparedStatementGenerator(this.factorySvc, dbctx.registry, this, dbctx.varEvaluator);
        return sqlgen;
    }

    @Override
    public SelectFuncHelper createSelectFuncHelper(DBAccessContext dbctx) {
        PostgresSelectFuncHelper sfhelper = new PostgresSelectFuncHelper(this.factorySvc, dbctx.registry);
        return sfhelper;
    }

    @Override
    public InsertStatementGenerator createPrepInsertSqlGen(DBAccessContext dbctx) {
        SqlNameFormatter nameFormatter = this.createNameFormatter(dbctx);
        PostgresInsertStatementGenerator sqlgen = new PostgresInsertStatementGenerator(this.factorySvc, dbctx.registry, nameFormatter);
        return sqlgen;
    }

    @Override
    public TableCreator createTableCreator(DBAccessContext dbctx) {
        SqlNameFormatter nameFormatter = this.createNameFormatter(dbctx);
        return new PostgresTableCreator(this.factorySvc, dbctx.registry, this.createFieldGenFactory(), nameFormatter);
    }
}

