/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.schema;

import java.util.List;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.db.DBExecutor;
import org.delia.db.DBInterface;
import org.delia.db.InsertContext;
import org.delia.db.schema.SchemaType;
import org.delia.type.DStructType;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;
import org.delia.valuebuilder.ScalarValueBuilder;
import org.delia.valuebuilder.StructValueBuilder;

public class MigrationRunner
extends ServiceBase {
    public static final String SCHEMA_TABLE = "DELIA_SCHEMA_VERSION";
    private DTypeRegistry registry;
    private DBExecutor dbexecutor;

    public MigrationRunner(FactoryService factorySvc, DBInterface dbInterface, DTypeRegistry registry, DBExecutor dbexecutor) {
        super(factorySvc);
        this.dbexecutor = dbexecutor;
        this.registry = registry;
    }

    public boolean performMigrations(String currentFingerprint, List<SchemaType> diffL, List<String> orderL) {
        this.log.log("running migration with %d steps:", orderL.size());
        for (String typeName : orderL) {
            for (SchemaType st : diffL) {
                if (!st.typeName.equals(typeName)) continue;
                if (st.isTblInsert()) {
                    this.log.log("  create-table: %s", st.typeName);
                    this.dbexecutor.createTable(st.typeName);
                    continue;
                }
                if (st.isFieldInsert()) {
                    this.log.log("  add-field: %s", st);
                    this.dbexecutor.createField(st.typeName, st.field);
                    continue;
                }
                if (st.isFieldRename()) {
                    this.log.log("  rename-field: %s %s", st, st.newName);
                    this.dbexecutor.renameField(st.typeName, st.field, st.newName);
                    continue;
                }
                if (st.isFieldAlterType()) {
                    this.log.log("  alter-field-type: %s %s", st, st.newName);
                    this.dbexecutor.alterFieldType(st.typeName, st.field, st.newName);
                    continue;
                }
                if (!st.isFieldAlter()) continue;
                this.log.log("  alter-field: %s '%s'", st, st.newName);
                this.dbexecutor.alterField(st.typeName, st.field, st.newName);
            }
        }
        for (SchemaType st : diffL) {
            if (st.isTblDelete()) {
                this.log.log("  delete-table: %s", st.typeName);
                this.doSoftDelete(st.typeName);
                continue;
            }
            if (st.isFieldDelete()) {
                this.log.log("  delete-field: %s", st);
                this.dbexecutor.deleteField(st.typeName, st.field);
                continue;
            }
            if (!st.isTblRename()) continue;
            this.log.log("  rename-table: %s %s", st, st.newName);
            this.dbexecutor.renameTable(st.typeName, st.newName);
        }
        DStructType dtype = this.registry.getSchemaVersionType();
        DValue dval = this.createSchemaObj(dtype, currentFingerprint);
        if (dval == null) {
            return false;
        }
        InsertContext ictx = new InsertContext();
        this.dbexecutor.executeInsert(dval, ictx);
        return true;
    }

    private void doSoftDelete(String typeName) {
        String backupName = String.format("%s__BAK", typeName);
        if (this.dbexecutor.execTableDetect(backupName)) {
            this.dbexecutor.deleteTable(backupName);
        }
        this.dbexecutor.renameTable(typeName, backupName);
        this.log.log("rename TBL: %s -> %s", typeName, backupName);
    }

    private void doSoftDeleteField(String typeName, String fieldName) {
        String backupName = String.format("%s__BAK", fieldName);
        if (this.dbexecutor.execTableDetect(backupName)) {
            this.dbexecutor.deleteTable(backupName);
        }
        this.dbexecutor.renameTable(typeName, backupName);
        this.log.log("rename TBL: %s -> %s", typeName, backupName);
    }

    private DValue createSchemaObj(DStructType type, String fingerprint) {
        StructValueBuilder structBuilder = new StructValueBuilder(type);
        ScalarValueBuilder builder = this.factorySvc.createScalarValueBuilder(this.registry);
        DValue dval = builder.buildString(fingerprint);
        structBuilder.addField("fingerprint", dval);
        boolean b = structBuilder.finish();
        if (!b) {
            return null;
        }
        dval = structBuilder.getDValue();
        return dval;
    }
}

