/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.schema;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.delia.type.BuiltInTypes;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.type.TypePair;

public class SchemaFingerprintGenerator {
    public String createFingerprint(DTypeRegistry registry) {
        String s = "";
        ConcurrentHashMap<DType, DType> dupMap = new ConcurrentHashMap<DType, DType>();
        List<DType> list = registry.getOrderedList();
        for (DType type : list) {
            if (this.isBuiltInType(type) || !type.isStructShape() || dupMap.containsKey(type = registry.getType(type.getName()))) continue;
            dupMap.put(type, type);
            s = s + String.format("%s", type.getName());
            String parent = type.getBaseType() == null ? "" : type.getBaseType().getName();
            s = s + String.format(":struct:%s{", parent);
            int i = 0;
            if (type.isStructShape()) {
                DStructType dtype = (DStructType)type;
                for (TypePair pair : dtype.getAllFields()) {
                    if (i > 0) {
                        s = s + ",";
                    }
                    s = s + this.genField(dtype, pair);
                    ++i;
                }
            }
            s = s + "}\n";
        }
        return s;
    }

    private String genField(DStructType dtype, TypePair pair) {
        String flags = "";
        if (dtype.fieldIsOptional(pair.name)) {
            flags = flags + "O";
        }
        if (dtype.fieldIsPrimaryKey(pair.name)) {
            flags = flags + "P";
        }
        if (dtype.fieldIsUnique(pair.name)) {
            flags = flags + "U";
        }
        if (dtype.fieldIsSerial(pair.name)) {
            flags = flags + "S";
        }
        String fldName = this.getTypeAsString(pair);
        String s = String.format("%s:%s:%s", pair.name, fldName, flags);
        return s;
    }

    private String getTypeAsString(TypePair pair) {
        try {
            BuiltInTypes fieldType = BuiltInTypes.valueOf(pair.type.getName());
            return BuiltInTypes.getDeliaTypeName(fieldType);
        }
        catch (Exception exception) {
            return pair.type.getName();
        }
    }

    private boolean isBuiltInType(DType type) {
        for (BuiltInTypes bintype : BuiltInTypes.values()) {
            if (!type.getName().equals(bintype.name())) continue;
            return true;
        }
        return false;
    }
}

