/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.delia.compiler.ast.FilterExp;
import org.delia.compiler.ast.IdentExp;
import org.delia.compiler.ast.QueryExp;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.db.DBAccessContext;
import org.delia.db.DBExecutor;
import org.delia.db.DBInterface;
import org.delia.db.QueryBuilderService;
import org.delia.db.QueryContext;
import org.delia.db.QuerySpec;
import org.delia.db.memdb.MemDBExecutor;
import org.delia.db.schema.FieldInfo;
import org.delia.db.schema.MigrationOptimizer;
import org.delia.db.schema.MigrationPlan;
import org.delia.db.schema.MigrationRunner;
import org.delia.db.schema.SchemaFingerprintGenerator;
import org.delia.db.schema.SchemaType;
import org.delia.runner.DoNothingVarEvaluator;
import org.delia.runner.QueryResponse;
import org.delia.runner.VarEvaluator;
import org.delia.sort.topo.DeliaTypeSorter;
import org.delia.type.DStructType;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;
import org.delia.typebuilder.FakeTypeCreator;
import org.delia.util.StringUtil;

public class SchemaMigrator
extends ServiceBase {
    public static final String SCHEMA_TABLE = "DELIA_SCHEMA_VERSION";
    private DTypeRegistry registry;
    private SchemaFingerprintGenerator fingerprintGenerator;
    private String currentFingerprint;
    private String dbFingerprint;
    private DBExecutor dbexecutor;
    private DBAccessContext dbctx;
    private MigrationRunner migrationRunner;
    private VarEvaluator varEvaluator;
    private MigrationOptimizer optimizer;

    public SchemaMigrator(FactoryService factorySvc, DBInterface dbInterface, DTypeRegistry registry, VarEvaluator varEvaluator) {
        super(factorySvc);
        this.dbctx = new DBAccessContext(registry, new DoNothingVarEvaluator());
        this.dbexecutor = dbInterface.createExector(this.dbctx);
        this.registry = registry;
        this.fingerprintGenerator = new SchemaFingerprintGenerator();
        this.varEvaluator = varEvaluator;
        FakeTypeCreator fakeCreator = new FakeTypeCreator();
        DStructType dtype = fakeCreator.createSchemaVersionType(registry, SCHEMA_TABLE);
        registry.setSchemaVersionType(dtype);
        this.migrationRunner = new MigrationRunner(factorySvc, dbInterface, registry, this.dbexecutor);
        this.optimizer = new MigrationOptimizer(factorySvc, dbInterface, registry, varEvaluator);
    }

    public void close() {
        this.dbexecutor.close();
    }

    public boolean createSchemaTableIfNeeded() {
        if (this.dbexecutor.execTableDetect(SCHEMA_TABLE)) {
            return true;
        }
        this.dbexecutor.createTable(SCHEMA_TABLE);
        return true;
    }

    public boolean dbNeedsMigration() {
        this.currentFingerprint = this.fingerprintGenerator.createFingerprint(this.registry);
        this.dbFingerprint = this.calcDBFingerprint();
        return !this.currentFingerprint.equals(this.dbFingerprint);
    }

    public boolean performMigrations(boolean doLowRiskChecks) {
        List<SchemaType> list = this.parseFingerprint(this.dbFingerprint);
        List<SchemaType> list2 = this.parseFingerprint(this.currentFingerprint);
        List<SchemaType> diffL = this.calcDiff(list, list2);
        diffL = this.optimizer.optimizeDiffs(diffL);
        boolean b = this.performMigrations(diffL, doLowRiskChecks);
        return b;
    }

    private FieldInfo parseFieldInfo(SchemaType st) {
        List<FieldInfo> flist1 = this.parseFields(st);
        FieldInfo f1 = this.findFieldIn(st.field, flist1);
        return f1;
    }

    public MigrationPlan generateMigrationPlan() {
        List<SchemaType> list = this.parseFingerprint(this.dbFingerprint);
        List<SchemaType> list2 = this.parseFingerprint(this.currentFingerprint);
        MigrationPlan plan = new MigrationPlan();
        plan.diffL = this.calcDiff(list, list2);
        return plan;
    }

    public MigrationPlan runMigrationPlan(MigrationPlan plan) {
        boolean b;
        plan.runResultFlag = b = this.performMigrations(plan.diffL, false);
        return plan;
    }

    public String calcDBFingerprint() {
        FilterExp filter = null;
        QuerySpec spec = new QuerySpec();
        spec.queryExp = new QueryExp(99, new IdentExp(SCHEMA_TABLE), filter, null);
        QueryContext qtx = new QueryContext();
        QueryResponse qresp = this.dbexecutor.executeQuery(spec, qtx);
        if (qresp.emptyResults()) {
            return "";
        }
        int n = qresp.dvalList.size();
        DValue dval = qresp.dvalList.get(n - 1);
        return dval.asStruct().getField("fingerprint").asString();
    }

    public List<SchemaType> parseFingerprint(String fingeprint) {
        String[] ar = fingeprint.split("\n");
        ArrayList<SchemaType> list = new ArrayList<SchemaType>();
        for (String line : ar) {
            if (line.trim().isEmpty()) continue;
            SchemaType schemaType = new SchemaType();
            schemaType.line = line;
            schemaType.typeName = StringUtils.substringBefore((String)line, (String)":");
            list.add(schemaType);
        }
        return list;
    }

    public String getCurrentFingerprint() {
        return this.currentFingerprint;
    }

    public String getDbFingerprint() {
        return this.dbFingerprint;
    }

    public List<SchemaType> calcDiff(List<SchemaType> list1, List<SchemaType> list2Param) {
        ArrayList<SchemaType> diffList = new ArrayList<SchemaType>();
        ArrayList<SchemaType> list2 = new ArrayList<SchemaType>(list2Param);
        for (SchemaType schema1 : list1) {
            SchemaType sc2 = this.findIn(schema1, list2);
            if (sc2 != null) {
                this.diffFields(schema1, sc2, diffList);
                list2.remove(sc2);
                continue;
            }
            schema1.action = "D";
            diffList.add(schema1);
        }
        for (SchemaType schema2 : list2) {
            schema2.action = "I";
            diffList.add(schema2);
        }
        return diffList;
    }

    private void diffFields(SchemaType st1, SchemaType st2, List<SchemaType> diffList) {
        List<FieldInfo> flist1 = this.parseFields(st1);
        List<FieldInfo> flist2 = this.parseFields(st2);
        ArrayList<FieldInfo> list2 = new ArrayList<FieldInfo>(flist2);
        for (FieldInfo finfo : flist1) {
            SchemaType st;
            FieldInfo f2 = this.findFieldIn(finfo, flist2);
            if (f2 != null) {
                String deltaFlags;
                if (!finfo.type.equals(f2.type)) {
                    st = new SchemaType();
                    st.typeName = st1.typeName;
                    st.line = st1.line;
                    st.action = "AT";
                    st.field = finfo.name;
                    st.newName = f2.type;
                    diffList.add(st);
                }
                if (!StringUtil.isNullOrEmpty(deltaFlags = this.calcDeltaFlags(finfo, f2))) {
                    SchemaType st3 = new SchemaType();
                    st3.typeName = st1.typeName;
                    st3.line = st1.line;
                    st3.action = "A";
                    st3.field = finfo.name;
                    st3.newName = deltaFlags;
                    diffList.add(st3);
                }
                list2.remove(f2);
                continue;
            }
            st = new SchemaType();
            st.typeName = st1.typeName;
            st.line = st1.line;
            st.action = "D";
            st.field = finfo.name;
            diffList.add(st);
        }
        for (FieldInfo f2 : list2) {
            SchemaType st = new SchemaType();
            st.typeName = st2.typeName;
            st.line = st2.line;
            st.action = "I";
            st.field = f2.name;
            diffList.add(st);
        }
    }

    private String calcDeltaFlags(FieldInfo finfo, FieldInfo f2) {
        char ch;
        int i;
        StringJoiner joiner = new StringJoiner(",");
        for (i = 0; i < finfo.flagStr.length(); ++i) {
            ch = finfo.flagStr.charAt(i);
            if (f2.flagStr.indexOf(ch) >= 0) continue;
            joiner.add(String.format("-%c", Character.valueOf(ch)));
        }
        for (i = 0; i < f2.flagStr.length(); ++i) {
            ch = f2.flagStr.charAt(i);
            if (finfo.flagStr.indexOf(ch) >= 0) continue;
            joiner.add(String.format("+%c", Character.valueOf(ch)));
        }
        return joiner.toString();
    }

    private FieldInfo findFieldIn(FieldInfo target, List<FieldInfo> flist2) {
        for (FieldInfo f2 : flist2) {
            if (!target.name.equals(f2.name)) continue;
            return f2;
        }
        return null;
    }

    private FieldInfo findFieldIn(String fieldName, List<FieldInfo> flist2) {
        for (FieldInfo f2 : flist2) {
            if (!fieldName.equals(f2.name)) continue;
            return f2;
        }
        return null;
    }

    private List<FieldInfo> parseFields(SchemaType schema1) {
        String[] ar;
        ArrayList<FieldInfo> list = new ArrayList<FieldInfo>();
        String s = StringUtils.substringAfter((String)schema1.line, (String)"{");
        s = StringUtils.substringBeforeLast((String)s, (String)"}");
        for (String ss : ar = s.split(",")) {
            FieldInfo finfo = new FieldInfo();
            finfo.name = StringUtils.substringBefore((String)ss, (String)":");
            finfo.type = StringUtils.substringBetween((String)ss, (String)":", (String)":");
            finfo.flagStr = StringUtils.substringAfterLast((String)ss, (String)":");
            list.add(finfo);
        }
        return list;
    }

    private SchemaType findIn(SchemaType st, List<SchemaType> list2) {
        for (SchemaType schema2 : list2) {
            if (!st.typeName.equals(schema2.typeName)) continue;
            return schema2;
        }
        return null;
    }

    public boolean performMigrations(List<SchemaType> diffL, boolean doLowRiskChecks) {
        DeliaTypeSorter typeSorter = new DeliaTypeSorter();
        List<String> orderL = typeSorter.topoSort(this.registry);
        if (!this.preRunCheck(diffL, orderL, doLowRiskChecks)) {
            this.log.logError("migration halted due to pre-migration check errors. No schema changes were made.", new Object[0]);
            return false;
        }
        return this.migrationRunner.performMigrations(this.currentFingerprint, diffL, orderL);
    }

    private boolean preRunCheck(List<SchemaType> diffL, List<String> orderL, boolean doLowRiskChecks) {
        int failCount = 0;
        for (SchemaType st : diffL) {
            if (st.isTblInsert() && this.registry.findTypeOrSchemaVersionType(st.typeName) == null) {
                this.log.logError("error: create-table for unknown type '%s'. ", st.typeName);
                ++failCount;
            }
            if (st.isTblDelete()) {
                if (this.doSoftDeletePreRunCheck(st.typeName)) continue;
                ++failCount;
                continue;
            }
            if (st.isFieldInsert()) {
                QueryExp exp;
                QueryBuilderService queryBuilder;
                QuerySpec spec;
                QueryResponse qresp;
                DValue dval;
                long numRecords;
                FieldInfo f1 = this.parseFieldInfo(st);
                if (!doLowRiskChecks || f1.flagStr.contains("O") || this.isMemDB() || (numRecords = (dval = (qresp = this.dbexecutor.executeQuery(spec = (queryBuilder = this.factorySvc.getQueryBuilderService()).buildSpec(exp = queryBuilder.createCountQuery(st.typeName), this.varEvaluator), new QueryContext())).getOne()).asLong()) <= 0L) continue;
                this.log.logError("error: adding mandatory field '%s.%s' ", st.typeName, st.field);
                ++failCount;
                continue;
            }
            if (st.isFieldDelete()) {
                if (this.doSoftFieldDeletePreRunCheck(st.typeName, st.field)) continue;
                ++failCount;
                continue;
            }
            if (st.isFieldAlterType() || !st.isFieldAlter()) continue;
            if (st.newName.contains("P")) {
                this.log.logError("error: not allowed to add/remove primaryKey '%s.%s' ", st.typeName, st.field);
                ++failCount;
            }
            if (!st.newName.contains("S")) continue;
            this.log.logError("error: not allowed to add/remove serial '%s.%s' ", st.typeName, st.field);
            ++failCount;
        }
        return failCount == 0;
    }

    private boolean isMemDB() {
        return this.dbexecutor instanceof MemDBExecutor;
    }

    private boolean doSoftDeletePreRunCheck(String typeName) {
        String backupName = String.format("%s__BAK", typeName);
        if (this.dbexecutor.execTableDetect(backupName)) {
            this.log.logError("Backup table '%s' already exists. You must delete this table first before running migration.", backupName);
            return false;
        }
        return true;
    }

    private boolean doSoftFieldDeletePreRunCheck(String typeName, String fieldName) {
        String backupName = String.format("%s__BAK", fieldName);
        if (this.dbexecutor.execFieldDetect(typeName, backupName)) {
            this.log.logError("Backup field '%s.%s' already exists. You must delete this field first before running migration.", typeName, backupName);
            return false;
        }
        return true;
    }
}

