/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.delia.db.DBErrorConverter;
import org.delia.db.sql.ConnectionFactory;
import org.delia.db.sql.ConnectionString;
import org.delia.log.Log;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    public ConnectionString connectionString;
    private DBErrorConverter errorConverter;
    private Log log;
    private boolean haveLoggedJDBC = false;

    public ConnectionFactoryImpl(ConnectionString connStr, Log log) {
        this.connectionString = connStr;
        this.log = log;
    }

    @Override
    public Connection createConnection() {
        Connection conn = null;
        try {
            if (!this.haveLoggedJDBC) {
                this.haveLoggedJDBC = true;
                this.log.log("JDBC: url: %s", this.connectionString.jdbcUrl);
                this.log.log("JDBC: user: %s, pwd: %s", this.connectionString.userName, this.connectionString.pwd);
            }
            conn = DriverManager.getConnection(this.connectionString.jdbcUrl, this.connectionString.userName, this.connectionString.pwd);
        }
        catch (SQLException e) {
            this.errorConverter.convertAndRethrowException(e);
        }
        return conn;
    }

    @Override
    public ConnectionString getConnectionString() {
        return this.connectionString;
    }

    @Override
    public void setErrorConverter(DBErrorConverter errorConverter) {
        this.errorConverter = errorConverter;
    }

    @Override
    public String getConnectionSummary() {
        return this.connectionString.jdbcUrl;
    }
}

