/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.sql;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.delia.core.DateFormatService;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.core.TimeZoneService;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.type.TypePair;
import org.delia.type.WrappedDate;

public class SqlDateGenerator
extends ServiceBase {
    private DTypeRegistry registry;
    private DateFormatService fmtSvc;

    public SqlDateGenerator(FactoryService factorySvc, DTypeRegistry registry) {
        super(factorySvc);
        this.registry = registry;
        this.fmtSvc = factorySvc.getDateFormatService();
    }

    String dateValueInSql(Object value) {
        if (value instanceof String) {
            return this.convertDateStringToSQLTimestamp((String)value);
        }
        if (value instanceof WrappedDate) {
            WrappedDate wdt = (WrappedDate)value;
            return this.convertDateToSQLTimestamp(wdt.getDate());
        }
        return String.format("%s", value.toString());
    }

    public String convertDateStringToSQLTimestamp(String value) {
        Date dt = this.fmtSvc.parse(value);
        return this.convertDateToSQLTimestamp(dt);
    }

    public String convertDateStringToSQLTimestamp2(String value) {
        Date dt = this.fmtSvc.parse(value);
        return this.fmtSvc.format(dt);
    }

    private String convertDateToSQLTimestamp(Date dt) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TimeZoneService tzSvc = this.factorySvc.getTimeZoneService();
        TimeZone tz = tzSvc.getDefaultTimeZone();
        sdf.setTimeZone(tz);
        String s = sdf.format(dt);
        return String.format("'%s'", s);
    }

    DType findFieldType(DStructType dtype, String fieldName) {
        for (TypePair pair : dtype.getAllFields()) {
            if (!pair.name.equals(fieldName)) continue;
            return pair.type;
        }
        return null;
    }
}

