/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.sql.prepared;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.db.sql.SqlNameFormatter;
import org.delia.db.sql.StrCreator;
import org.delia.db.sql.prepared.SqlStatement;
import org.delia.db.sql.prepared.TableInfoHelper;
import org.delia.db.sql.table.TableInfo;
import org.delia.relation.RelationInfo;
import org.delia.type.DRelation;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;
import org.delia.type.TypePair;
import org.delia.util.DRuleHelper;
import org.delia.util.DValueHelper;
import org.delia.util.DeliaExceptionHelper;

public class InsertStatementGenerator
extends ServiceBase {
    private DTypeRegistry registry;
    private SqlNameFormatter nameFormatter;
    protected boolean specialHandlingForEmptyInsertFlag = false;

    public InsertStatementGenerator(FactoryService factorySvc, DTypeRegistry registry, SqlNameFormatter nameFormatter) {
        super(factorySvc);
        this.registry = registry;
        this.nameFormatter = nameFormatter;
    }

    private String tblName(String typeName) {
        return this.nameFormatter.convert(typeName);
    }

    private String tblName(DType dtype) {
        return this.nameFormatter.convert(dtype);
    }

    public SqlStatement generateInsert(DValue dval, List<TableInfo> tblInfoL) {
        HashMap<String, DRelation> map = new HashMap<String, DRelation>();
        SqlStatement statement = new SqlStatement();
        String sql = this.doGenerateInsert(dval, map, statement);
        statement.sql = sql = sql + this.doGenerateAssocInsertIfNeeded(dval, tblInfoL, map, statement);
        return statement;
    }

    private String doGenerateInsert(DValue dval, Map<String, DRelation> map, SqlStatement statement) {
        DStructType dtype = (DStructType)dval.getType();
        StrCreator sc = new StrCreator();
        sc.o("INSERT INTO %s (", this.tblName(dtype));
        int index = 0;
        for (TypePair pair : dtype.getAllFields()) {
            DValue inner;
            if (pair.type.isStructShape()) {
                if (!this.shouldGenerateFKConstraint(pair, dtype)) continue;
                if (DRuleHelper.isManyToManyRelation(pair, dtype)) {
                    inner = dval.asStruct().getField(pair.name);
                    if (inner == null) continue;
                    map.put(pair.name, inner.asRelation());
                    continue;
                }
            }
            if ((inner = dval.asStruct().getField(pair.name)) == null) continue;
            if (dtype.fieldIsSerial(pair.name)) {
                DeliaExceptionHelper.throwError("serial-value-cannot-be-provided", "Type %s, field %s - do not specify a value for a serial field", dtype.getName(), pair.name);
            }
            if (index > 0) {
                sc.o(", ", new String[0]);
            }
            sc.o(pair.name, new String[0]);
            ++index;
        }
        sc.o(")", new String[0]);
        sc.nl();
        if (index == 0 && this.specialHandlingForEmptyInsertFlag) {
            String s;
            sc.str = s = sc.str.substring(0, sc.str.indexOf(40));
            sc.o(" values (default);", new String[0]);
            return sc.str;
        }
        sc.o("VALUES (", new String[0]);
        index = 0;
        for (TypePair pair : dtype.getAllFields()) {
            if (DRuleHelper.isManyToManyRelation(pair, dtype) || !this.generateInsertField(sc, dval, pair, dtype, index, statement)) continue;
            ++index;
        }
        sc.o(");", new String[0]);
        sc.nl();
        return sc.str;
    }

    private boolean shouldGenerateFKConstraint(TypePair pair, DStructType dtype) {
        RelationInfo info = DRuleHelper.findMatchingRuleInfo(dtype, pair);
        return info != null && !info.isParent;
    }

    private String doGenerateAssocInsertIfNeeded(DValue dval, List<TableInfo> tblInfoL, Map<String, DRelation> map, SqlStatement statement) {
        String sql = "";
        if (map.isEmpty()) {
            return sql;
        }
        DStructType dtype = (DStructType)dval.getType();
        for (TypePair pair : dtype.getAllFields()) {
            RelationInfo info = DRuleHelper.findManyToManyRelation(pair, dtype);
            if (info == null) continue;
            TableInfo tblinfo = TableInfoHelper.findTableInfo(tblInfoL, pair, info);
            sql = sql + this.genAssocInsert(dval, pair, tblinfo, map, statement);
        }
        return sql;
    }

    private String genAssocInsert(DValue dval, TypePair pair, TableInfo tblinfo, Map<String, DRelation> map, SqlStatement statement) {
        DStructType dtype = (DStructType)dval.getType();
        StrCreator sc = new StrCreator();
        sc.o("INSERT INTO %s (", this.tblName(tblinfo.assocTblName));
        RelationInfo info = DRuleHelper.findOtherSideOneOrMany(pair.type, dtype);
        sc.o("leftv", new String[0]);
        sc.o(",", new String[0]);
        sc.nl();
        sc.o("rightv", new String[0]);
        sc.o(")", new String[0]);
        sc.nl();
        sc.o("VALUES (", new String[0]);
        TypePair xpair = DValueHelper.findPrimaryKeyFieldPair(info.nearType);
        DRelation drel = map.get(tblinfo.fieldName);
        if (drel == null) {
            RelationInfo info2 = DRuleHelper.findManyToManyRelation(pair, dtype);
            xpair = DValueHelper.findPrimaryKeyFieldPair(info2.nearType);
            DValue zz = dval.asStruct().getField(info2.fieldName);
            DValue id = zz.asRelation().getForeignKey();
            TypePair main = DValueHelper.findPrimaryKeyFieldPair(dval.getType());
            DValue mainId = dval.asStruct().getField(main.name);
            DRelation drelMain = new DRelation(dval.getType().getName(), mainId);
            this.genAssocValues(sc, dval, drelMain, info2, xpair, id, statement);
        } else {
            xpair = DValueHelper.findPrimaryKeyFieldPair(info.farType);
            DValue id = dval.asStruct().getField(xpair.name);
            this.genAssocValues(sc, dval, drel, info, xpair, id, statement);
        }
        return sc.str;
    }

    private void genAssocValues(StrCreator sc, DValue dval, DRelation drel, RelationInfo info, TypePair xpair, DValue id, SqlStatement statement) {
        if (drel.isMultipleKey()) {
            int index = 0;
            for (DValue keyVal : drel.getMultipleKeys()) {
                statement.paramL.add(id);
                sc.o("?", new String[0]);
                sc.o(",", new String[0]);
                if (keyVal == null) {
                    statement.paramL.add(null);
                    sc.o("?", new String[0]);
                } else {
                    statement.paramL.add(keyVal);
                    sc.o("?", new String[0]);
                }
                if (index < drel.getMultipleKeys().size() - 1) {
                    sc.o("),(", new String[0]);
                }
                ++index;
            }
        } else {
            statement.paramL.add(id);
            sc.o("?", new String[0]);
            sc.o(",", new String[0]);
            this.genRelationValue(sc, drel, 0, statement);
        }
        sc.o(");", new String[0]);
        sc.nl();
    }

    private boolean generateInsertField(StrCreator sc, DValue dval, TypePair pair, DStructType dtype, int index, SqlStatement statement) {
        DType innerType = pair.type;
        DValue inner = dval.asStruct().getField(pair.name);
        if (inner == null) {
            return false;
        }
        if (innerType.isStructShape()) {
            if (!this.shouldGenerateFKConstraint(pair, dtype)) {
                return false;
            }
            DRelation drel = inner.asRelation();
            this.genRelationValue(sc, drel, index, statement);
            return true;
        }
        if (index > 0) {
            sc.o(",", new String[0]);
        }
        statement.paramL.add(inner);
        sc.o("?", new String[0]);
        return true;
    }

    private void genRelationValue(StrCreator sc, DRelation drel, int index, SqlStatement statement) {
        DValue keyVal = drel.getForeignKey();
        if (index > 0) {
            sc.o(",", new String[0]);
        }
        if (keyVal == null) {
            statement.paramL.add(null);
            sc.o("null", new String[0]);
            return;
        }
        statement.paramL.add(keyVal);
        sc.o("?", new String[0]);
    }

    public String generateUpdateBody(StrCreator sc, DValue dval, Map<String, DRelation> map, SqlStatement statement) {
        DStructType dtype = (DStructType)dval.getType();
        int index = 0;
        for (TypePair pair : dtype.getAllFields()) {
            DValue inner;
            if (pair.type.isStructShape()) {
                if (!this.shouldGenerateFKConstraint(pair, dtype)) continue;
                if (DRuleHelper.isManyToManyRelation(pair, dtype)) {
                    inner = dval.asStruct().getField(pair.name);
                    if (inner == null) continue;
                    map.put(pair.name, inner.asRelation());
                    continue;
                }
            }
            if ((inner = dval.asStruct().getField(pair.name)) == null) continue;
            if (index > 0) {
                sc.o(", ", new String[0]);
            }
            sc.o(pair.name, new String[0]);
            sc.o("=", new String[0]);
            this.generateInsertField(sc, dval, pair, dtype, 0, statement);
            ++index;
        }
        if (index == 0) {
            return "";
        }
        return sc.str;
    }
}

