/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.sql.table;

import java.util.ArrayList;
import java.util.List;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.db.sql.SqlNameFormatter;
import org.delia.db.sql.StrCreator;
import org.delia.db.sql.table.ConstraintGen;
import org.delia.db.sql.table.FieldGen;
import org.delia.db.sql.table.FieldGenFactory;
import org.delia.db.sql.table.SqlElement;
import org.delia.db.sql.table.TableInfo;
import org.delia.relation.RelationInfo;
import org.delia.type.DStructType;
import org.delia.type.DTypeRegistry;
import org.delia.type.TypePair;
import org.delia.util.DRuleHelper;
import org.delia.util.DValueHelper;
import org.delia.util.DeliaExceptionHelper;

public class TableCreator
extends ServiceBase {
    protected DTypeRegistry registry;
    public List<TableInfo> alreadyCreatedL = new ArrayList<TableInfo>();
    protected FieldGenFactory fieldgenFactory;
    protected SqlNameFormatter nameFormatter;

    public TableCreator(FactoryService factorySvc, DTypeRegistry registry, FieldGenFactory fieldgenFactory, SqlNameFormatter nameFormatter) {
        super(factorySvc);
        this.registry = registry;
        this.fieldgenFactory = fieldgenFactory;
        this.nameFormatter = nameFormatter;
    }

    public String generateCreateTable(String typeName, DStructType dtype) {
        if (dtype == null) {
            dtype = (DStructType)this.registry.getType(typeName);
        }
        this.alreadyCreatedL.add(new TableInfo(typeName, null));
        StrCreator sc = new StrCreator();
        sc.o("CREATE TABLE %s (", typeName);
        sc.nl();
        int index = 0;
        ArrayList<SqlElement> fieldL = new ArrayList<SqlElement>();
        int manyToManyFieldCount = 0;
        for (TypePair pair : dtype.getAllFields()) {
            if (this.isManyToManyRelation(pair, dtype)) {
                ++manyToManyFieldCount;
                continue;
            }
            if (DRuleHelper.isParentRelation(dtype, pair)) continue;
            FieldGen field = this.fieldgenFactory.createFieldGen(this.registry, pair, dtype);
            fieldL.add(field);
            ++index;
        }
        for (TypePair pair : dtype.getAllFields()) {
            ConstraintGen constraint;
            if (!pair.type.isStructShape() || this.isManyToManyRelation(pair, dtype) || (constraint = this.generateFKConstraint(sc, pair, dtype)) == null) continue;
            fieldL.add(constraint);
        }
        index = 0;
        for (SqlElement field : fieldL) {
            field.generateField(sc);
            if (index + 1 < fieldL.size()) {
                sc.o(",", new String[0]);
                sc.nl();
            }
            ++index;
        }
        sc.nl();
        sc.o(");", new String[0]);
        sc.nl();
        if (manyToManyFieldCount > 0) {
            sc.nl();
            for (TypePair pair : dtype.getAllFields()) {
                if (!this.isManyToManyRelation(pair, dtype)) continue;
                this.generateAssocTable(sc, pair, dtype);
            }
        }
        return sc.str;
    }

    protected boolean shouldGenerateFKConstraint(TypePair pair, DStructType dtype) {
        RelationInfo info = DRuleHelper.findMatchingRuleInfo(dtype, pair);
        return info != null && !info.isParent;
    }

    protected boolean isManyToManyRelation(TypePair pair, DStructType dtype) {
        return DRuleHelper.isManyToManyRelation(pair, dtype);
    }

    protected ConstraintGen generateFKConstraint(StrCreator sc, TypePair pair, DStructType dtype) {
        if (!this.shouldGenerateFKConstraint(pair, dtype)) {
            return null;
        }
        return this.fieldgenFactory.generateFKConstraint(this.registry, pair, dtype);
    }

    protected void generateAssocTable(StrCreator sc, TypePair xpair, DStructType dtype) {
        TypePair copy;
        RelationInfo info = DRuleHelper.findMatchingRuleInfo(dtype, xpair);
        String tbl1 = info.nearType.getName();
        String tbl2 = info.farType.getName();
        if (!this.haveCreatedTable(tbl1) || !this.haveCreatedTable(tbl2)) {
            return;
        }
        String assocTableName = String.format("%s%sAssoc", tbl1, tbl2);
        TableInfo tblinfo = this.alreadyCreatedL.get(this.alreadyCreatedL.size() - 1);
        tblinfo.assocTblName = assocTableName;
        tblinfo.tbl1 = tbl1;
        tblinfo.tbl2 = tbl2;
        tblinfo.fieldName = xpair.name;
        sc.o("CREATE TABLE %s (", assocTableName);
        sc.nl();
        int index = 0;
        ArrayList<SqlElement> fieldL = new ArrayList<SqlElement>();
        int n = dtype.getAllFields().size();
        for (TypePair pair : dtype.getAllFields()) {
            if (!this.isManyToManyRelation(pair, dtype)) continue;
            copy = new TypePair("leftv", pair.type);
            FieldGen field = this.fieldgenFactory.createFieldGen(this.registry, copy, dtype);
            fieldL.add(field);
            TypePair xx = DValueHelper.findPrimaryKeyFieldPair(info.farType);
            copy = new TypePair("rightv", xx.type);
            field = this.fieldgenFactory.createFieldGen(this.registry, copy, info.farType);
            fieldL.add(field);
            ++index;
        }
        for (TypePair pair : dtype.getAllFields()) {
            if (!this.isManyToManyRelation(pair, dtype)) continue;
            copy = new TypePair("leftv", info.nearType);
            ConstraintGen constraint = this.fieldgenFactory.generateFKConstraint(this.registry, copy, info.nearType);
            if (constraint != null) {
                fieldL.add(constraint);
            }
            if ((constraint = this.fieldgenFactory.generateFKConstraint(this.registry, copy = new TypePair("rightv", info.farType), info.farType)) != null) {
                fieldL.add(constraint);
            }
            ++index;
        }
        index = 0;
        for (SqlElement field : fieldL) {
            field.generateField(sc);
            if (index + 1 < fieldL.size()) {
                sc.o(",", new String[0]);
                sc.nl();
            }
            ++index;
        }
        sc.o(");", new String[0]);
        sc.nl();
    }

    protected boolean haveCreatedTable(String tbl1) {
        for (TableInfo info : this.alreadyCreatedL) {
            if (!info.tblName.equals(tbl1)) continue;
            return true;
        }
        return false;
    }

    public String generateCreateField(String typeName, DStructType dtype, String fieldName) {
        ConstraintGen constraint;
        if (dtype == null) {
            dtype = (DStructType)this.registry.getType(typeName);
        }
        StrCreator sc = new StrCreator();
        sc.o("ALTER TABLE %s ADD  ", typeName);
        sc.nl();
        ArrayList<SqlElement> fieldL = new ArrayList<SqlElement>();
        int manyToManyFieldCount = 0;
        TypePair pair = DValueHelper.findField(dtype, fieldName);
        if (this.isManyToManyRelation(pair, dtype)) {
            ++manyToManyFieldCount;
        } else {
            FieldGen field = this.fieldgenFactory.createFieldGen(this.registry, pair, dtype);
            fieldL.add(field);
        }
        if (pair.type.isStructShape() && !this.isManyToManyRelation(pair, dtype) && (constraint = this.generateFKConstraint(sc, pair, dtype)) != null) {
            fieldL.add(constraint);
        }
        int index = 0;
        for (SqlElement ff : fieldL) {
            ff.generateField(sc);
            if (index + 1 < fieldL.size()) {
                sc.o(",", new String[0]);
                sc.nl();
            }
            ++index;
        }
        sc.nl();
        if (manyToManyFieldCount > 0) {
            sc.nl();
            if (this.isManyToManyRelation(pair, dtype)) {
                this.generateAssocTable(sc, pair, dtype);
            }
        }
        return sc.str;
    }

    public String generateRenameField(String tableName, String fieldName, String newName) {
        StrCreator sc = new StrCreator();
        sc.o("ALTER TABLE %s ALTER COLUMN %s", this.tblName(tableName), fieldName);
        sc.o(" RENAME TO %s", newName);
        return sc.str;
    }

    public String tblName(String tableName) {
        return this.nameFormatter.convert(tableName);
    }

    public String generateAlterFieldType(String tableName, String fieldName, String newFieldType) {
        StrCreator sc = new StrCreator();
        this.doAlterColumnPrefix(sc, tableName, fieldName);
        DStructType dtype = (DStructType)this.registry.getType(tableName);
        TypePair pair = DValueHelper.findField(dtype, fieldName);
        FieldGen fieldGen = this.fieldgenFactory.createFieldGen(this.registry, pair, dtype);
        String sqlType = fieldGen.deliaToSql(pair);
        sc.o(" SET DATA TYPE %s", sqlType);
        return sc.str;
    }

    public String generateAlterField(String tableName, String fieldName, String deltaFlags, String constraintName) {
        String[] ar;
        StrCreator sc = new StrCreator();
        String[] stringArray = ar = deltaFlags.split(",");
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String delta;
            switch (delta = stringArray[i]) {
                case "+O": {
                    this.doAlterColumnOptional(sc, tableName, fieldName, true);
                    continue block12;
                }
                case "-O": {
                    this.doAlterColumnOptional(sc, tableName, fieldName, false);
                    continue block12;
                }
                case "+U": {
                    this.doAlterColumnUnique(sc, tableName, fieldName, true, constraintName);
                    continue block12;
                }
                case "-U": {
                    this.doAlterColumnUnique(sc, tableName, fieldName, false, constraintName);
                    continue block12;
                }
                default: {
                    String msg = String.format("Field '%s.%s' - field change '%s' not supported", tableName, fieldName, delta);
                    DeliaExceptionHelper.throwError("unsupported-alter-field-change", msg, new Object[0]);
                }
            }
        }
        return sc.str;
    }

    protected void doAlterColumnUnique(StrCreator sc, String tableName, String fieldName, boolean b, String constraintName) {
        this.doAlterTablePrefix(sc, tableName);
        if (b) {
            sc.o(" ADD CONSTRAINT %S UNIQUE(%s)", constraintName, fieldName);
        } else {
            sc.o(" DROP CONSTRAINT %S", constraintName);
        }
        sc.o(";\n", new String[0]);
    }

    protected void doAlterColumnOptional(StrCreator sc, String tableName, String fieldName, boolean b) {
        this.doAlterColumnPrefix(sc, tableName, fieldName);
        if (b) {
            sc.o(" DROP NOT NULL", new String[0]);
        } else {
            sc.o(" SET NOT NULL", new String[0]);
        }
        sc.o(";\n", new String[0]);
    }

    protected void doAlterColumnPrefix(StrCreator sc, String tableName, String fieldName) {
        sc.o("ALTER TABLE %s ALTER COLUMN %s", this.tblName(tableName), fieldName);
    }

    protected void doAlterTablePrefix(StrCreator sc, String tableName) {
        sc.o("ALTER TABLE %s ", this.tblName(tableName));
    }
}

