/*
 * Decompiled with CFR 0.152.
 */
package org.delia.log;

import org.delia.log.Log;
import org.delia.log.LogLevel;

public class SimpleLog
implements Log {
    private LogLevel level = LogLevel.INFO;

    @Override
    public void log(String fmt, Object ... args) {
        if (this.exceeds(LogLevel.INFO)) {
            this.doLog(LogLevel.INFO, fmt, args);
        }
    }

    @Override
    public void setLevel(LogLevel level) {
        this.level = level;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public void logDebug(String fmt, Object ... args) {
        if (this.exceeds(LogLevel.DEBUG)) {
            this.doLog(LogLevel.DEBUG, fmt, args);
        }
    }

    @Override
    public void logError(String fmt, Object ... args) {
        if (this.exceeds(LogLevel.ERROR)) {
            this.doLog(LogLevel.ERROR, fmt, args);
        }
    }

    protected void doLog(LogLevel level, String fmt, Object ... args) {
        String prefix = this.createPrefix(level);
        if (args.length == 0) {
            System.out.println(prefix + fmt);
        } else {
            String s = String.format(fmt, args);
            System.out.println(prefix + s);
        }
    }

    protected String createPrefix(LogLevel info) {
        long threadId = Thread.currentThread().getId();
        String prefix = String.format("[%d] ", threadId);
        return prefix;
    }

    protected boolean exceeds(LogLevel info) {
        return this.level.getLevelNum() >= info.getLevelNum();
    }

    @Override
    public void logException(LogLevel targetLevel, String message, Throwable ex) {
        if (this.exceeds(targetLevel)) {
            this.log("EXCEPTION: %s", message);
            ex.printStackTrace();
        }
    }
}

