/*
 * Decompiled with CFR 0.152.
 */
package org.delia.log;

import java.util.List;
import org.delia.log.Log;
import org.delia.log.LogFactory;
import org.delia.log.LogLevel;
import org.delia.log.LogLevelMapBuilder;
import org.delia.log.SimpleLog;

public class SimpleLogFactory
implements LogFactory {
    private LogLevel defaultLevel = LogLevel.INFO;
    private LogLevelMapBuilder levelMapBuilder = new LogLevelMapBuilder();

    @Override
    public Log create(String name) {
        SimpleLog log = new SimpleLog();
        log.setLevel(this.calcLevel(name));
        return log;
    }

    @Override
    public Log create(Class<?> clazz) {
        SimpleLog log = new SimpleLog();
        log.setLevel(this.calcLevel(clazz.getName()));
        return log;
    }

    @Override
    public void setDefaultLogLevel(LogLevel level) {
        this.defaultLevel = level;
    }

    @Override
    public LogLevel getDefaultLogLevel() {
        return this.defaultLevel;
    }

    @Override
    public void setLogLevelMap(List<String> levelMapList) {
        this.levelMapBuilder.buildMap(levelMapList);
    }

    protected LogLevel calcLevel(String name) {
        return this.levelMapBuilder.calcLevel(name, this.defaultLevel);
    }
}

