/*
 * Decompiled with CFR 0.152.
 */
package org.delia.queryresponse.function;

import java.util.ArrayList;
import java.util.List;
import org.delia.compiler.ast.QueryExp;
import org.delia.queryresponse.QueryFuncContext;
import org.delia.queryresponse.QueryResponseFunctionBase;
import org.delia.runner.QueryResponse;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;
import org.delia.util.DeliaExceptionHelper;

public class FirstFunction
extends QueryResponseFunctionBase {
    private boolean firstFlag;
    private boolean ithFlag;

    public FirstFunction(DTypeRegistry registry, boolean firstFlag, boolean ithFlag) {
        super(registry);
        this.firstFlag = firstFlag;
        this.ithFlag = ithFlag;
    }

    @Override
    public QueryResponse process(String fnName, QueryExp queryExp, QueryResponse qresp, QueryFuncContext ctx) {
        int n;
        if (!this.ithFlag && this.dbDoesThis(ctx)) {
            return qresp;
        }
        List<DValue> dvalList = ctx.getDValList();
        if (dvalList == null || dvalList.size() <= 1) {
            return qresp;
        }
        ArrayList<DValue> newlist = new ArrayList<DValue>();
        if (this.ithFlag) {
            n = this.getIntArg(queryExp, ctx);
            if (n < 0 || n >= dvalList.size()) {
                DeliaExceptionHelper.throwError("queryfn-ith-bad-index", "bad index!! %d", n);
            }
        } else {
            n = this.firstFlag ? 0 : dvalList.size() - 1;
        }
        DValue dval = dvalList.get(n);
        newlist.add(dval);
        qresp.dvalList = newlist;
        return qresp;
    }
}

