/*
 * Decompiled with CFR 0.152.
 */
package org.delia.repl;

import org.delia.api.Delia;
import org.delia.db.DBAccessContext;
import org.delia.db.DBExecutor;
import org.delia.db.DBInterface;
import org.delia.repl.Cmd;
import org.delia.repl.CmdBase;
import org.delia.repl.ReplRunner;
import org.delia.runner.ResultValue;

public class DBDeleteTableCmd
extends CmdBase {
    public DBDeleteTableCmd() {
        super("db table delete", null);
    }

    @Override
    public Cmd isReplCmd(String src) {
        if (this.isMatch(src)) {
            DBDeleteTableCmd cmd = new DBDeleteTableCmd();
            cmd.cmd = this.name;
            cmd.arg1 = this.parseArg1(src);
            return cmd;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultValue runCmd(Cmd cmd, ReplRunner runner) {
        Delia delia = runner.getDelia();
        DBInterface dbInterface = delia.getDBInterface();
        DBAccessContext dbctx = new DBAccessContext(null, null);
        try (DBExecutor exec = dbInterface.createExector(dbctx);){
            String tableName = cmd.arg1;
            if (exec.execTableDetect(tableName)) {
                exec.deleteTable(cmd.arg1);
                this.log(String.format("deleted table '%s'", cmd.arg1));
            } else {
                this.log("can't find that table: " + tableName);
            }
        }
        return this.createEmptyRes();
    }
}

