/*
 * Decompiled with CFR 0.152.
 */
package org.delia.repl;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.delia.api.DeliaSession;
import org.delia.builder.ConnectionInfo;
import org.delia.repl.ReplRunner;
import org.delia.runner.ResultValue;

public class DeliaRepl {
    ReplRunner runner;
    private boolean shouldQuit = false;
    private String baseDir;
    private ConnectionInfo connectionInfo;

    public DeliaRepl(ConnectionInfo info, String baseDir) {
        this.baseDir = baseDir;
        this.connectionInfo = info;
        this.runner = new ReplRunner(info);
    }

    public void run() {
        this.log(String.format("Delia REPL - dbType: %s", this.connectionInfo.dbType.name()));
        this.log("");
        while (!this.shouldQuit) {
            try {
                this.doRunOne();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void doRunOne() throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String prefix = this.buildPrefix();
        System.out.print(String.format("%s> ", prefix));
        String input = reader.readLine();
        input = input.trim();
        if (this.isQuit(input)) {
            this.shouldQuit = true;
            return;
        }
        if (input.trim().isEmpty()) {
            return;
        }
        if (input.equals("restart")) {
            this.runner.restart();
            return;
        }
        if (input.equals("d2")) {
            input = "run delia2.txt";
        }
        input = this.doPathFixup(input, "run");
        input = this.doPathFixup(input, "load");
        input = this.doPathFixup(input, "r");
        input = this.doPathFixup(input, "continue");
        input = this.doPathFixup(input, "c");
        input = this.doPathFixup(input, "load");
        input = this.doPathFixup(input, "migration run");
        input = this.doPathFixup(input, "mr");
        boolean inSess = this.runner.inSession();
        ResultValue res = this.runner.executeReplCmdOrDelia(input);
        String output = this.runner.toReplResult(res);
        if (res.ok) {
            output = !inSess && this.runner.inSession() ? output + String.format("\nOK - session '%s' created.\n", this.runner.getSessionName()) : output + "\nOK\n";
        }
        this.log(output);
    }

    private boolean isQuit(String input) {
        return (input = input.toLowerCase()).equals("q") || input.equals("quit") || input.equals("exit");
    }

    private String buildPrefix() {
        DeliaSession sess = this.runner.getMostRecentSess();
        String name = this.runner.getSessionName();
        name = name == null ? "session" : name;
        String prefix = sess == null ? "(no session)" : name;
        return prefix;
    }

    private void log(String s) {
        System.out.println(s);
    }

    private String doPathFixup(String input, String cmd) {
        int n = cmd.length() + 1;
        if (input.startsWith(cmd + " ")) {
            String s = input.substring(n);
            if (!input.contains("/") && !input.contains("\\")) {
                input = cmd + " " + this.baseDir + s;
            }
        }
        return input;
    }
}

