/*
 * Decompiled with CFR 0.152.
 */
package org.delia.repl;

import org.apache.commons.lang3.StringUtils;
import org.delia.api.Delia;
import org.delia.api.MigrationAction;
import org.delia.db.schema.MigrationPlan;
import org.delia.db.schema.SchemaType;
import org.delia.repl.Cmd;
import org.delia.repl.CmdBase;
import org.delia.repl.ReplRunner;
import org.delia.runner.ResultValue;

public class GenerateMigrationPlanCmd
extends CmdBase {
    public GenerateMigrationPlanCmd() {
        super("migration generate", "mg");
        this.expectSpace = false;
    }

    @Override
    public Cmd isReplCmd(String src) {
        if (this.isMatch(src)) {
            GenerateMigrationPlanCmd cmd = new GenerateMigrationPlanCmd();
            cmd.cmd = this.name;
            return cmd;
        }
        return null;
    }

    @Override
    public ResultValue runCmd(Cmd cmd, ReplRunner runner) {
        String src = runner.getLoadSrc();
        if (StringUtils.isEmpty((CharSequence)src)) {
            this.log("You must define some types first, before you can generate a plan.");
            return this.createEmptyRes();
        }
        Delia delia = runner.getDelia();
        delia.getOptions().migrationAction = MigrationAction.GENERATE_MIGRATION_PLAN;
        delia.getOptions().enableExecution = false;
        ResultValue res = runner.runDelia(src);
        delia.getOptions().migrationAction = MigrationAction.MIGRATE;
        delia.getOptions().enableExecution = true;
        MigrationPlan migrationPlan = (MigrationPlan)res.val;
        runner.setCurrentMigrationPlan(migrationPlan);
        this.log("generated migration plan: ");
        for (SchemaType ss : migrationPlan.diffL) {
            this.log("  " + ss.getSummary());
        }
        this.log("");
        return res;
    }
}

