/*
 * Decompiled with CFR 0.152.
 */
package org.delia.repl;

import org.delia.api.Delia;
import org.delia.db.DBInterface;
import org.delia.db.h2.H2DBInterface;
import org.delia.db.postgres.PostgresDBInterface;
import org.delia.repl.Cmd;
import org.delia.repl.CmdBase;
import org.delia.repl.ReplRunner;
import org.delia.runner.ResultValue;

public class ListDBTablesCmd
extends CmdBase {
    public ListDBTablesCmd() {
        super("db table list", "ldb");
        this.expectSpace = false;
    }

    @Override
    public Cmd isReplCmd(String src) {
        if (this.isMatch(src)) {
            ListDBTablesCmd cmd = new ListDBTablesCmd();
            cmd.cmd = this.name;
            return cmd;
        }
        return null;
    }

    @Override
    public ResultValue runCmd(Cmd cmd, ReplRunner runner) {
        Delia delia = runner.getDelia();
        DBInterface dbInterface = delia.getDBInterface();
        if (dbInterface instanceof H2DBInterface) {
            H2DBInterface h2db = (H2DBInterface)dbInterface;
            h2db.enumerateAllTables(delia.getLog());
        }
        if (dbInterface instanceof PostgresDBInterface) {
            PostgresDBInterface pgdb = (PostgresDBInterface)dbInterface;
            pgdb.enumerateAllTables(delia.getLog());
        }
        return this.createEmptyRes();
    }
}

