/*
 * Decompiled with CFR 0.152.
 */
package org.delia.repl;

import java.util.ArrayList;
import java.util.List;
import org.delia.api.DeliaSession;
import org.delia.repl.Cmd;
import org.delia.repl.CmdBase;
import org.delia.repl.ReplRunner;
import org.delia.runner.ResultValue;
import org.delia.type.BuiltInTypes;
import org.delia.type.DValue;

public class ListVarsCmd
extends CmdBase {
    public ListVarsCmd() {
        super("list vars", "lv");
        this.expectSpace = false;
    }

    @Override
    public Cmd isReplCmd(String src) {
        if (this.isMatch(src)) {
            ListVarsCmd cmd = new ListVarsCmd();
            cmd.cmd = this.name;
            return cmd;
        }
        return null;
    }

    @Override
    public ResultValue runCmd(Cmd cmd, ReplRunner runner) {
        DeliaSession sess = runner.getMostRecentSess();
        if (sess == null) {
            this.log("no vars have been defined.");
            return this.createEmptyRes();
        }
        List<String> list = this.getAllVars(sess);
        String s = String.format("Number of vars: %d", list.size());
        this.log(s);
        int maxLen = 5;
        for (String varName : list) {
            if (varName.length() <= maxLen) continue;
            maxLen = varName.length();
        }
        for (String varName : list) {
            ResultValue res = sess.getExecutionContext().varMap.get(varName);
            String type = "";
            String sss = "";
            List<DValue> dvals = res.getAsDValueList();
            if (dvals != null) {
                type = dvals.get(0).getType().getName();
                sss = dvals.size() > 1 ? String.format("%d values", dvals.size()) : "";
            } else if (res.shape != null) {
                Object obj = res.val;
                type = BuiltInTypes.getDeliaTypeNameFromShape(res.shape);
                if (obj instanceof DValue) {
                    DValue dval = (DValue)obj;
                    sss = dval.asString();
                } else {
                    sss = obj == null ? "null" : obj.toString();
                }
            }
            String fmt = String.format("%d", maxLen);
            fmt = "  %-" + fmt + "s %-6s %s";
            s = String.format(fmt, varName, type, sss);
            this.log(s);
        }
        return this.createEmptyRes();
    }

    private List<String> getAllVars(DeliaSession sess) {
        ArrayList<String> list = new ArrayList<String>();
        if (sess == null || sess.getExecutionContext() == null) {
            return list;
        }
        for (String var : sess.getExecutionContext().varMap.keySet()) {
            if (var.equals("$$")) continue;
            list.add(var);
        }
        return list;
    }
}

