/*
 * Decompiled with CFR 0.152.
 */
package org.delia.repl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.delia.api.Delia;
import org.delia.api.DeliaSession;
import org.delia.api.MigrationAction;
import org.delia.builder.ConnectionInfo;
import org.delia.builder.DeliaBuilder;
import org.delia.compiler.generate.DeliaGeneratePhase;
import org.delia.compiler.generate.SimpleFormatOutputGenerator;
import org.delia.db.DBInterface;
import org.delia.db.memdb.MemDBInterface;
import org.delia.db.schema.MigrationPlan;
import org.delia.log.Log;
import org.delia.log.SimpleLog;
import org.delia.repl.CleanTablesCmd;
import org.delia.repl.Cmd;
import org.delia.repl.CmdBase;
import org.delia.repl.ContinueCmd;
import org.delia.repl.DBDeleteTableCmd;
import org.delia.repl.DBLoggingCmd;
import org.delia.repl.GenerateMigrationPlanCmd;
import org.delia.repl.InternalCmd;
import org.delia.repl.ListDBTablesCmd;
import org.delia.repl.ListTypesCmd;
import org.delia.repl.ListVarsCmd;
import org.delia.repl.LoadCmd;
import org.delia.repl.RunCmd;
import org.delia.repl.RunMigrationPlanCmd;
import org.delia.repl.StatusCmd;
import org.delia.runner.DeliaException;
import org.delia.runner.QueryResponse;
import org.delia.runner.ResultValue;
import org.delia.type.BuiltInTypes;
import org.delia.type.DValue;
import org.delia.type.Shape;
import org.delia.util.DeliaExceptionHelper;
import org.delia.util.StringUtil;
import org.delia.util.TextFileReader;
import org.h2.store.fs.FileUtils;

public class ReplRunner {
    private Log log = new SimpleLog();
    private Delia delia;
    private DBInterface dbInterface;
    private DeliaSession mostRecentSess;
    private DeliaException mostRecentException;
    private List<Cmd> allCmdsL = new ArrayList<Cmd>();
    private String loadSrc;
    private MigrationPlan currentMigrationPlan;
    private ConnectionInfo connectionInfo;
    private String sessionName;
    public static boolean disableSQLLoggingDuringSchemaMigration = true;

    public ReplRunner(ConnectionInfo info) {
        this.connectionInfo = info;
        this.restart();
        this.allCmdsL.add(new LoadCmd());
        this.allCmdsL.add(new RunCmd());
        this.allCmdsL.add(new GenerateMigrationPlanCmd());
        this.allCmdsL.add(new RunMigrationPlanCmd());
        this.allCmdsL.add(new ListTypesCmd());
        this.allCmdsL.add(new ListVarsCmd());
        this.allCmdsL.add(new CleanTablesCmd());
        this.allCmdsL.add(new ListDBTablesCmd());
        this.allCmdsL.add(new DBDeleteTableCmd());
        this.allCmdsL.add(new ContinueCmd());
        this.allCmdsL.add(new StatusCmd());
        this.allCmdsL.add(new DBLoggingCmd());
    }

    public void restart() {
        this.delia = DeliaBuilder.withConnection(this.connectionInfo).build();
        this.dbInterface = this.delia.getDBInterface();
        this.dbInterface.getCapabilities().setRequiresSchemaMigration(true);
        this.dbInterface.enableSQLLogging(false);
        if (this.dbInterface instanceof MemDBInterface) {
            MemDBInterface memdb = (MemDBInterface)this.dbInterface;
            memdb.createTablesAsNeededFlag = true;
        }
        for (Cmd cmdx : this.allCmdsL) {
            CmdBase cmd = (CmdBase)cmdx;
            cmd.setFactorySvc(this.delia.getFactoryService());
        }
        this.mostRecentSess = null;
        this.mostRecentException = null;
        this.loadSrc = null;
        this.currentMigrationPlan = null;
        this.sessionName = null;
    }

    public ResultValue runFromFile(String path) {
        this.log.log("reading: %s", path);
        TextFileReader reader = new TextFileReader();
        List<String> lines = reader.readFile(path);
        String src = StringUtil.convertToSingleString(lines);
        this.sessionName = this.createSessionName(path);
        return this.executeReplCmdOrDelia(src);
    }

    public ResultValue continueFromFile(String path) {
        this.log.log("reading: %s", path);
        TextFileReader reader = new TextFileReader();
        List<String> lines = reader.readFile(path);
        String src = StringUtil.convertToSingleString(lines);
        return this.continueDelia(src);
    }

    public ResultValue loadFromFile(String path) {
        String src;
        this.log.log("reading: %s", path);
        TextFileReader reader = new TextFileReader();
        List<String> lines = reader.readFile(path);
        this.loadSrc = src = StringUtil.convertToSingleString(lines);
        this.sessionName = this.createSessionName(path);
        this.delia.getOptions().migrationAction = MigrationAction.DO_NOTHING;
        this.delia.getOptions().enableExecution = false;
        ResultValue res = this.executeReplCmdOrDelia(src);
        this.delia.getOptions().migrationAction = MigrationAction.MIGRATE;
        this.delia.getOptions().enableExecution = true;
        return res;
    }

    private String createSessionName(String path) {
        return FilenameUtils.getBaseName((String)path);
    }

    public ResultValue executeReplCmdOrDelia(String src) {
        Cmd cmd = this.isReplCmd(src = src.trim());
        if (cmd != null) {
            return this.runReplCmd(cmd);
        }
        if (!src.contains(" ") && !src.contains("[")) {
            this.log.log("unknown command or statement", new Object[0]);
            ResultValue res = new ResultValue();
            res.ok = true;
            res.val = null;
            return res;
        }
        if (this.inSession()) {
            return this.continueDelia(src);
        }
        return this.runDelia(src);
    }

    public ResultValue runDelia(String src) {
        this.mostRecentSess = null;
        ResultValue res = new ResultValue();
        try {
            DeliaSession sess = this.delia.beginSession(src);
            res = sess.getFinalResult();
            this.mostRecentSess = sess;
            Integer n = sess.getExecutionContext().registry.size();
            if (n > 7) {
                this.loadSrc = src;
            }
        }
        catch (DeliaException e) {
            this.mostRecentException = e;
        }
        return res;
    }

    public ResultValue runMPlan(String src, MigrationPlan plan) {
        this.mostRecentSess = null;
        ResultValue res = new ResultValue();
        try {
            DeliaSession sess;
            this.mostRecentSess = sess = this.delia.executeMigrationPlan(src, plan);
            return sess.getFinalResult();
        }
        catch (DeliaException e) {
            this.mostRecentException = e;
            return res;
        }
    }

    private Cmd isReplCmd(String src) {
        for (Cmd ccc : this.allCmdsL) {
            if ((ccc = ccc.isReplCmd(src)) == null) continue;
            return ccc;
        }
        InternalCmd cmd = null;
        if (src.startsWith("? ")) {
            cmd = new InternalCmd();
            ((Cmd)cmd).cmd = "?";
            ((Cmd)cmd).arg1 = src.substring(((Cmd)cmd).cmd.length() + 1);
            return cmd;
        }
        return cmd;
    }

    private ResultValue runReplCmd(Cmd cmd) {
        String ss = cmd.cmd + (cmd.arg1 == null ? "" : " " + cmd.arg1);
        ResultValue res = null;
        try {
            res = this.doReplCmd(cmd);
        }
        catch (DeliaException e) {
            this.mostRecentException = e;
            res = new ResultValue();
        }
        return res;
    }

    private ResultValue doReplCmd(Cmd cmd) {
        if (!(cmd instanceof InternalCmd)) {
            return cmd.runCmd(cmd, this);
        }
        switch (cmd.cmd) {
            case "?": {
                String arg1 = cmd.arg1;
                if (!this.mostRecentSess.getExecutionContext().varMap.containsKey(arg1)) {
                    DeliaExceptionHelper.throwError("repl", "can't find variable: " + arg1, new Object[0]);
                    break;
                }
                ResultValue res = this.mostRecentSess.getExecutionContext().varMap.get(arg1);
                res.varName = "?";
                res.ok = true;
                return res;
            }
        }
        return null;
    }

    public ResultValue continueDelia(String src) {
        this.delia.getOptions().disableSQLLoggingDuringSchemaMigration = disableSQLLoggingDuringSchemaMigration;
        ResultValue res = new ResultValue();
        try {
            res = this.delia.continueExecution(src, this.mostRecentSess);
        }
        catch (DeliaException e) {
            this.mostRecentException = e;
        }
        return res;
    }

    public String toReplResult(ResultValue res) {
        if (res.ok) {
            String valStr;
            if (res.val == null) {
                return "";
            }
            if (res.val instanceof QueryResponse) {
                String valStr2 = this.doQueryResp(res);
                String typeName = this.getType(res);
                if (res.varName.equals("?")) {
                    return valStr2;
                }
                if (valStr2.isEmpty()) {
                    if (res.varName.equals("$$")) {
                        String s = String.format("null (0 records found)", new Object[0]);
                        return s;
                    }
                    String s = String.format("created variable %s = null (0 records found)", res.varName);
                    return s;
                }
                if (res.varName.equals("$$")) {
                    String s = String.format("result: (%s) = %s", typeName, valStr2);
                    return s;
                }
                String s = String.format("created variable %s (%s) = %s", res.varName, typeName, valStr2);
                return s;
            }
            if (res.val instanceof MigrationPlan) {
                MigrationPlan plan = (MigrationPlan)res.val;
                if (plan.diffL.isEmpty()) {
                    String s = String.format("plan has 0 steps. The database is up to date.", plan.diffL.size());
                    return s;
                }
                String s = String.format("plan has %d steps.", plan.diffL.size());
                return s;
            }
            DValue dval = (DValue)res.val;
            String string = valStr = dval.getType().isShape(Shape.STRING) ? String.format("'%s'", dval.asString()) : dval.asString();
            if (res.varName.equals("?")) {
                return valStr;
            }
            String s = String.format("created variable %s (%s) = %s", res.varName, this.shapeStr(dval), valStr);
            return s;
        }
        String s = "Delia execution failed.\n";
        String tmp = String.format("  error: %s", this.mostRecentException.getMessage());
        tmp = tmp.replace("\n", "\n    ");
        s = s + tmp;
        s = s + "\n";
        return s;
    }

    private String getType(ResultValue res) {
        QueryResponse qresp = (QueryResponse)res.val;
        if (qresp.dvalList.isEmpty()) {
            return "??";
        }
        DValue dval = qresp.dvalList.get(0);
        return dval.getType().getName();
    }

    private String doQueryResp(ResultValue res) {
        QueryResponse qresp = (QueryResponse)res.val;
        SimpleFormatOutputGenerator gen = new SimpleFormatOutputGenerator();
        gen.includeVPrefix = false;
        DeliaGeneratePhase phase = this.mostRecentSess.getExecutionContext().generator;
        boolean multiple = qresp.dvalList.size() > 1;
        String resultStr = multiple ? "[" : "";
        for (DValue dval : qresp.dvalList) {
            gen.outputL.clear();
            boolean b = phase.generateValue(gen, dval, "a");
            if (!b) {
                return "sdfsdf";
            }
            String s = StringUtil.convertToSingleString(gen.outputL);
            int pos = s.indexOf(123);
            if (pos >= 0) {
                s = s.substring(pos);
            }
            resultStr = resultStr + s;
        }
        resultStr = resultStr + (multiple ? "]" : "");
        return resultStr;
    }

    private Object shapeStr(DValue dval) {
        String s = BuiltInTypes.convertDTypeNameToDeliaName(dval.getType().getName());
        return s;
    }

    public DeliaSession getMostRecentSess() {
        return this.mostRecentSess;
    }

    public boolean inSession() {
        return this.mostRecentSess != null;
    }

    public Delia getDelia() {
        return this.delia;
    }

    public MigrationPlan getCurrentMigrationPlan() {
        return this.currentMigrationPlan;
    }

    public void setCurrentMigrationPlan(MigrationPlan currentMigrationPlan) {
        this.currentMigrationPlan = currentMigrationPlan;
    }

    public String getLoadSrc() {
        return this.loadSrc;
    }

    public void setLoadSrc(String loadSrc) {
        this.loadSrc = loadSrc;
    }

    public boolean doesFileExist(String path) {
        return FileUtils.exists((String)path);
    }

    public String getSessionName() {
        return this.sessionName;
    }
}

