/*
 * Decompiled with CFR 0.152.
 */
package org.delia.repl.migration;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.db.schema.SchemaType;
import org.delia.repl.migration.MigrationStep;

public class MigrationParser
extends ServiceBase {
    private int failCount;
    private String currentName;

    public MigrationParser(FactoryService factorySvc) {
        super(factorySvc);
    }

    public boolean parse(List<String> lines, List<MigrationStep> list) {
        this.failCount = 0;
        list.clear();
        for (String line : lines) {
            String arg2;
            String arg1;
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            if (this.matches(line, "create-table")) {
                arg1 = this.parseArg1(line);
                this.failIfHasDot(arg1);
                list.add(new MigrationStep(this.currentName, arg1));
                continue;
            }
            if (this.matches(line, "delete-table")) {
                arg1 = this.parseArg1(line);
                this.failIfHasDot(arg1);
                list.add(new MigrationStep(this.currentName, arg1));
                continue;
            }
            if (this.matches(line, "rename-table")) {
                arg1 = this.parseArg1(line);
                arg2 = this.parseArg2(line);
                this.failIfHasDot(arg1);
                this.failIfHasDot(arg2);
                list.add(new MigrationStep(this.currentName, arg1, arg2));
                continue;
            }
            if (this.matches(line, "add-field")) {
                arg1 = this.parseArg1(line);
                this.failIfNoDot(arg1);
                list.add(new MigrationStep(this.currentName, arg1));
                continue;
            }
            if (this.matches(line, "delete-field")) {
                arg1 = this.parseArg1(line);
                this.failIfNoDot(arg1);
                list.add(new MigrationStep(this.currentName, arg1));
                continue;
            }
            if (this.matches(line, "rename-field")) {
                arg1 = this.parseArg1(line);
                arg2 = this.parseArg2(line);
                this.failIfNoDot(arg1);
                this.failIfHasDot(arg2);
                list.add(new MigrationStep(this.currentName, arg1, arg2));
                continue;
            }
            if (this.matches(line, "alter-field")) {
                arg1 = this.parseArg1(line);
                this.failIfNoDot(arg1);
                list.add(new MigrationStep(this.currentName, arg1));
                continue;
            }
            ++this.failCount;
        }
        return this.failCount == 0;
    }

    public List<SchemaType> convertToSchemaType(List<MigrationStep> steps) {
        ArrayList<SchemaType> list = new ArrayList<SchemaType>();
        for (MigrationStep step : steps) {
            SchemaType st = this.buildST(step);
            list.add(st);
        }
        return list;
    }

    private SchemaType buildST(MigrationStep step) {
        SchemaType st = new SchemaType();
        switch (step.name) {
            case "create-table": {
                st.action = "I";
                st.typeName = step.arg1;
                break;
            }
            case "delete-table": {
                st.action = "D";
                st.typeName = step.arg1;
                break;
            }
            case "rename-table": {
                st.action = "U";
                st.typeName = step.arg1;
                st.newName = step.arg2;
                break;
            }
            case "add-field": {
                st.action = "I";
                st.typeName = this.firstPart(step.arg1);
                st.field = this.secondPart(step.arg1);
                break;
            }
            case "delete-field": {
                st.action = "D";
                st.typeName = this.firstPart(step.arg1);
                st.field = this.secondPart(step.arg1);
                break;
            }
            case "rename-field": {
                st.action = "U";
                st.typeName = this.firstPart(step.arg1);
                st.field = this.secondPart(step.arg1);
                st.newName = step.arg2;
            }
            case "alter-field": {
                st.action = "U";
                st.typeName = this.firstPart(step.arg1);
                st.field = this.secondPart(step.arg1);
            }
        }
        return st;
    }

    private String firstPart(String arg1) {
        return StringUtils.substringBefore((String)arg1, (String)".");
    }

    private String secondPart(String arg1) {
        return StringUtils.substringAfter((String)arg1, (String)".");
    }

    private void failIfHasDot(String arg1) {
        if (arg1 != null && arg1.contains(".")) {
            ++this.failCount;
        }
    }

    private void failIfNoDot(String arg1) {
        if (arg1 != null && !arg1.contains(".")) {
            ++this.failCount;
        }
    }

    private boolean matches(String line, String name) {
        if (line.startsWith(name)) {
            this.currentName = name;
            return true;
        }
        return false;
    }

    private String parseArg1(String line) {
        int pos = line.indexOf(32);
        if (pos < 0) {
            ++this.failCount;
            return null;
        }
        String s = line.substring(pos);
        pos = (s = s.trim()).indexOf(32);
        if (pos > 0) {
            s = s.substring(0, pos);
        }
        return s.trim();
    }

    private String parseArg2(String line) {
        int pos = line.indexOf(32);
        if (pos < 0) {
            return null;
        }
        String s = line.substring(pos);
        pos = (s = s.trim()).indexOf(32);
        if (pos < 0) {
            ++this.failCount;
            return null;
        }
        if (pos > 0) {
            s = s.substring(pos);
        }
        return s.trim();
    }

    public int getFailCount() {
        return this.failCount;
    }
}

