/*
 * Decompiled with CFR 0.152.
 */
package org.delia.rule;

import org.apache.commons.lang3.StringUtils;
import org.delia.rule.DRule;
import org.delia.rule.DRuleContext;
import org.delia.rule.RuleGuard;
import org.delia.type.DValue;

public abstract class DRuleBase
implements DRule {
    private boolean polarity = true;
    private String name;
    private RuleGuard guard;

    public DRuleBase(String name, RuleGuard guard) {
        this.name = name;
        this.guard = guard;
    }

    public DRuleBase(String name, boolean polarity) {
        this.name = name;
        this.polarity = polarity;
    }

    @Override
    public boolean validate(DValue dval, DRuleContext ctx) {
        boolean pass = this.onValidate(dval, ctx);
        if (!this.polarity) {
            boolean bl = pass = !pass;
            if (!pass) {
                String subj = this.getSubject();
                subj = StringUtils.isEmpty((CharSequence)subj) ? "" : subj + ".";
                String msg = String.format("NOT %s%s() failed", subj, this.name);
                ctx.addError(this, msg);
            }
        }
        return pass;
    }

    protected abstract boolean onValidate(DValue var1, DRuleContext var2);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object exec(DValue dval, DRuleContext ctx) {
        return null;
    }

    @Override
    public void setPolarity(boolean polarity) {
        this.polarity = polarity;
    }

    @Override
    public boolean executeGuard(DValue dval) {
        boolean b = this.guard.shouldExecRule(dval);
        return b;
    }
}

