/*
 * Decompiled with CFR 0.152.
 */
package org.delia.rule;

import java.util.List;
import org.delia.db.DBCapabilties;
import org.delia.error.DeliaError;
import org.delia.error.ErrorTracker;
import org.delia.rule.DRule;
import org.delia.runner.FetchRunner;

public class DRuleContext {
    private ErrorTracker et;
    private String ruleText;
    private boolean planModeFlg;
    private boolean enableRelationModifierFlag;
    private boolean populateFKsFlag;
    private DBCapabilties dbCapabilities;
    private FetchRunner fetchRunner;

    public DRuleContext(ErrorTracker et, String ruleText, boolean enableRelationModifierFlag, DBCapabilties dbCapabilties, boolean populateFKsFlag, FetchRunner fetchRunner) {
        this.et = et;
        this.ruleText = ruleText;
        this.enableRelationModifierFlag = enableRelationModifierFlag;
        this.dbCapabilities = dbCapabilties;
        this.populateFKsFlag = populateFKsFlag;
        this.fetchRunner = fetchRunner;
    }

    public DeliaError addError(String id, String msg) {
        String msg2 = String.format("%s - in rule: %s", msg, this.ruleText);
        DeliaError err = this.et.add(id, msg2);
        return err;
    }

    public DeliaError addError(DRule rule, String msg) {
        return this.addError("rule-" + rule.getName(), msg);
    }

    public boolean hasErrors() {
        return !this.et.areNoErrors();
    }

    public String getRuleText() {
        return this.ruleText;
    }

    public List<DeliaError> getErrors() {
        return this.et.getErrors();
    }

    public boolean isPlanModeFlg() {
        return this.planModeFlg;
    }

    public void setPlanModeFlg(boolean planModeFlg) {
        this.planModeFlg = planModeFlg;
    }

    public boolean isEnableRelationModifierFlag() {
        return this.enableRelationModifierFlag;
    }

    public DBCapabilties getDBCapabilities() {
        return this.dbCapabilities;
    }

    public boolean isPopulateFKsFlag() {
        return this.populateFKsFlag;
    }

    public FetchRunner getFetchRunner() {
        return this.fetchRunner;
    }
}

