/*
 * Decompiled with CFR 0.152.
 */
package org.delia.rule.rules;

import org.delia.rule.DRuleBase;
import org.delia.rule.DRuleContext;
import org.delia.rule.RuleGuard;
import org.delia.rule.RuleOperand;
import org.delia.rule.RuleRuleOperand;
import org.delia.type.DValue;
import org.delia.type.Shape;

public class SampleRule
extends DRuleBase {
    private RuleOperand oper1;
    private String op;
    private RuleOperand oper2;

    public SampleRule(RuleGuard guard, RuleOperand oper1, String op, RuleOperand oper2) {
        super("sample", guard);
        this.oper1 = oper1;
        this.op = op;
        this.oper2 = oper2;
    }

    @Override
    protected boolean onValidate(DValue dval, DRuleContext ctx) {
        Comparable<?> obj1 = this.getAsObject(this.oper1, dval, ctx);
        Comparable<?> obj2 = this.getAsObject(this.oper2, dval, ctx);
        boolean b = false;
        switch (this.op) {
            case "<": {
                b = obj1.compareTo(obj2) < 0;
                break;
            }
            case "<=": {
                b = obj1.compareTo(obj2) <= 0;
                break;
            }
            case ">": {
                b = obj1.compareTo(obj2) > 0;
                break;
            }
            case ">=": {
                b = obj1.compareTo(obj2) >= 0;
                break;
            }
        }
        if (!b) {
            String s1 = String.format("%s", obj1);
            String s2 = String.format("%s", obj2);
            String msg = String.format("rulefail '%s' in '%s'", s1, s2);
            ctx.addError(this, msg);
        }
        return b;
    }

    private Comparable<?> getAsObject(RuleOperand oper, DValue dval, DRuleContext ctx) {
        if (oper instanceof RuleRuleOperand) {
            RuleRuleOperand rro = (RuleRuleOperand)oper;
            Comparable obj = (Comparable)rro.exec(dval, ctx);
            return obj;
        }
        Shape shape = oper.getShape(dval);
        if (shape == null) {
            return null;
        }
        switch (shape) {
            case INTEGER: {
                return oper.asInt(dval);
            }
        }
        return oper.asString(dval);
    }

    @Override
    public boolean dependsOn(String fieldName) {
        return this.oper1.dependsOn(fieldName) || this.oper2.dependsOn(fieldName);
    }

    @Override
    public String getSubject() {
        return "???";
    }
}

