/*
 * Decompiled with CFR 0.152.
 */
package org.delia.runner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.delia.compiler.ast.DsonExp;
import org.delia.compiler.ast.DsonFieldExp;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.IdentExp;
import org.delia.compiler.ast.ListExp;
import org.delia.compiler.ast.NullExp;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.error.DetailedError;
import org.delia.error.ErrorTracker;
import org.delia.runner.ConversionResult;
import org.delia.runner.VarEvaluator;
import org.delia.sprig.SprigService;
import org.delia.type.BuiltInTypes;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;
import org.delia.type.Shape;
import org.delia.type.TypePair;
import org.delia.valuebuilder.PartialStructValueBuilder;
import org.delia.valuebuilder.RelationValueBuilder;
import org.delia.valuebuilder.ScalarValueBuilder;
import org.delia.valuebuilder.StructValueBuilder;

public class DsonToDValueConverter
extends ServiceBase {
    private DTypeRegistry registry;
    private VarEvaluator varEvaluator;
    private ScalarValueBuilder builder;
    private SprigService sprigSvc;

    public DsonToDValueConverter(FactoryService factorySvc, ErrorTracker localET, DTypeRegistry registry, VarEvaluator varEvaluator, SprigService sprigSvc) {
        super(factorySvc);
        this.registry = registry;
        this.varEvaluator = varEvaluator;
        this.et = localET;
        this.builder = new ScalarValueBuilder(factorySvc, registry);
        this.sprigSvc = sprigSvc;
    }

    public DValue convertOne(String typeName, DsonExp dsonExp, ConversionResult cres) {
        return this.doConvertOne(typeName, dsonExp, false, cres);
    }

    public DValue convertOnePartial(String typeName, DsonExp dsonExp) {
        return this.doConvertOne(typeName, dsonExp, true, null);
    }

    private DValue doConvertOne(String typeName, DsonExp dsonExp, boolean isPartial, ConversionResult cres) {
        DType dtype = this.registry.getType(typeName);
        if (dtype == null) {
            return null;
        }
        DStructType structType = (DStructType)dtype;
        if (structType.getAllFields().isEmpty()) {
            this.et.add("cant-insert-empty-type", String.format("type '%s' has no fields. Can't execute insert.", dtype.getName()));
            return null;
        }
        StructValueBuilder structBuilder = isPartial ? new PartialStructValueBuilder(structType) : new StructValueBuilder(structType);
        DValue dval = this.buildValue(structType, dsonExp, structBuilder, cres);
        return dval;
    }

    private DValue buildValue(DStructType dtype, DsonExp dsonExp, StructValueBuilder structBuilder, ConversionResult cres) {
        if (cres != null) {
            cres.extraMap = new HashMap<String, DValue>();
        }
        DValue dval = this.doBuildValue(dtype, dsonExp, structBuilder, cres);
        return dval;
    }

    private DValue doBuildValue(DStructType dtype, DsonExp dsonExp, StructValueBuilder structBuilder, ConversionResult cres) {
        for (Exp exp : dsonExp.argL) {
            DsonFieldExp fieldExp = (DsonFieldExp)exp;
            String fieldName = fieldExp.getFieldName();
            DType fieldType = this.findFieldType(dtype, fieldName);
            if (this.sprigSvc.haveEnabledFor(dtype.getName(), fieldName) && cres != null) {
                cres.extraMap.put(fieldName, this.builder.buildInt(fieldExp.exp.strValue()));
                continue;
            }
            if (fieldType == null) {
                this.et.add("field-not-found", String.format("type '%s': can't find field '%s'", dtype.getName(), fieldName));
                return null;
            }
            DValue inner = this.buildInner(fieldExp, fieldType);
            structBuilder.addField(fieldName, inner);
        }
        boolean b = structBuilder.finish();
        if (!b) {
            for (DetailedError err : structBuilder.getValidationErrors()) {
                this.et.add(err);
            }
            return null;
        }
        DValue dValue = structBuilder.getDValue();
        return dValue;
    }

    private DType findFieldType(DStructType dtype, String fieldName) {
        for (TypePair pair : dtype.getAllFields()) {
            if (!pair.name.equals(fieldName)) continue;
            return pair.type;
        }
        return null;
    }

    private DValue buildInner(DsonFieldExp fieldExp, DType fieldType) {
        if (fieldExp.exp instanceof NullExp) {
            return null;
        }
        String input = this.evalFieldExp(fieldExp, fieldType);
        if (input == null) {
            return null;
        }
        if (Shape.STRING.equals((Object)fieldType.getShape())) {
            DValue dval = this.builder.buildString(input, fieldType);
            return dval;
        }
        if (Shape.INTEGER.equals((Object)fieldType.getShape())) {
            DValue dval = this.builder.buildInt(input, fieldType);
            return dval;
        }
        if (Shape.LONG.equals((Object)fieldType.getShape())) {
            DValue dval = this.builder.buildLong(input, fieldType);
            return dval;
        }
        if (Shape.NUMBER.equals((Object)fieldType.getShape())) {
            DValue dval = this.builder.buildNumber(input, fieldType);
            return dval;
        }
        if (Shape.BOOLEAN.equals((Object)fieldType.getShape())) {
            DValue dval = this.builder.buildBoolean(input, fieldType);
            return dval;
        }
        if (Shape.DATE.equals((Object)fieldType.getShape())) {
            DValue dval = this.builder.buildDate(input, fieldType);
            return dval;
        }
        if (Shape.STRUCT.equals((Object)fieldType.getShape())) {
            DType relType = this.registry.getType(BuiltInTypes.RELATION_SHAPE);
            RelationValueBuilder rbuilder = new RelationValueBuilder(relType, fieldType.getName(), this.registry);
            if (fieldExp.exp instanceof ListExp) {
                List<DValue> elementL = this.buildList((ListExp)fieldExp.exp, fieldType.getName());
                rbuilder.buildFromList(elementL);
            } else {
                rbuilder.buildFromString(input);
            }
            boolean b = rbuilder.finish();
            if (!b) {
                for (DetailedError err : rbuilder.getValidationErrors()) {
                    this.et.add(err);
                }
                return null;
            }
            DValue dval = rbuilder.getDValue();
            return dval;
        }
        return null;
    }

    private List<DValue> buildList(ListExp listExp, String typeName) {
        ArrayList<DValue> resultL = new ArrayList<DValue>();
        for (Exp exp : listExp.valueL) {
            String s = exp instanceof IdentExp ? this.varEvaluator.evalVarAsString(exp.strValue(), typeName) : exp.strValue();
            DValue dval = this.builder.buildInt(s);
            resultL.add(dval);
        }
        return resultL;
    }

    private String evalFieldExp(DsonFieldExp fieldExp, DType fieldType) {
        boolean b = this.sprigSvc.haveEnabledFor(fieldType.getName());
        if (b || fieldExp.exp instanceof IdentExp) {
            return this.varEvaluator.evalVarAsString(fieldExp.exp.strValue(), fieldType.getName());
        }
        return fieldExp.exp.strValue();
    }
}

