/*
 * Decompiled with CFR 0.152.
 */
package org.delia.runner;

import java.util.Date;
import java.util.List;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.IdentExp;
import org.delia.compiler.ast.ListExp;
import org.delia.compiler.ast.QueryExp;
import org.delia.core.DateFormatService;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.error.DeliaError;
import org.delia.runner.DeliaException;
import org.delia.runner.VarEvaluator;
import org.delia.type.DValue;
import org.delia.type.Shape;

public class FilterEvaluator
extends ServiceBase {
    public QueryExp queryExp;
    public DValue resolvedFilterVars;
    private VarEvaluator varEvaluator;
    private DateFormatService fmtSvc;

    public FilterEvaluator(FactoryService factorySvc, VarEvaluator varEvaluator) {
        super(factorySvc);
        this.varEvaluator = varEvaluator;
        this.fmtSvc = factorySvc.getDateFormatService();
    }

    public void init(QueryExp queryExp) {
        this.queryExp = queryExp;
        if (queryExp.filter != null && queryExp.filter.cond instanceof IdentExp) {
            String varName = queryExp.filter.cond.strValue();
            List<DValue> list = this.varEvaluator.lookupVar(varName);
            if (list.isEmpty() || list.size() > 1) {
                String msg = String.format("var eval failed: %s", varName);
                DeliaError err = this.et.add("varEval failed", "var eval failed: %s", msg);
                throw new DeliaException(err);
            }
            this.resolvedFilterVars = list.get(0);
        }
    }

    public boolean isEqualTo(DValue dval) {
        String target = this.queryExp.filter.cond.strValue();
        if (this.resolvedFilterVars != null) {
            target = this.resolvedFilterVars.asString();
        }
        return this.doIsEqualTo(dval, target);
    }

    private boolean doIsEqualTo(DValue dval, Object target) {
        if (dval.getType().isShape(Shape.DATE)) {
            Date dt = this.fmtSvc.parse(target.toString());
            return dval.asDate().equals(dt);
        }
        String tmp = dval.asString();
        return tmp != null && tmp.equals(target);
    }

    public boolean isIn(DValue key, ListExp listExp) {
        for (Exp exp : listExp.valueL) {
            if (!this.doIsEqualTo(key, exp.strValue())) continue;
            return true;
        }
        return false;
    }
}

