/*
 * Decompiled with CFR 0.152.
 */
package org.delia.runner;

import org.delia.compiler.ast.BooleanExp;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.IntegerExp;
import org.delia.compiler.ast.LongExp;
import org.delia.compiler.ast.NullExp;
import org.delia.compiler.ast.NumberExp;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.type.BuiltInTypes;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;
import org.delia.type.Shape;
import org.delia.valuebuilder.ScalarValueBuilder;

public class ScalarBuilder
extends ServiceBase {
    private DTypeRegistry registry;
    private ScalarValueBuilder builder;

    public ScalarBuilder(FactoryService factorySvc, DTypeRegistry registry) {
        super(factorySvc);
        this.registry = registry;
        this.builder = factorySvc.createScalarValueBuilder(registry);
    }

    public DValue buildDValue(Exp valueExp, String typeName) {
        if (valueExp instanceof NullExp) {
            return null;
        }
        DValue dval = typeName == null ? this.createBuilder(valueExp) : this.createBuilderExplicit(valueExp, typeName);
        return dval;
    }

    private DValue createBuilderExplicit(Exp valueExp, String typeName) {
        TypeInfo info = new TypeInfo();
        if (this.isType("int", typeName, info)) {
            if (!(valueExp instanceof IntegerExp)) {
                this.wrongTypeError(valueExp, typeName, "int");
                return null;
            }
            IntegerExp exp = (IntegerExp)valueExp;
            return this.builder.buildInt(exp.val, info.type);
        }
        if (this.isType("long", typeName, info)) {
            if (valueExp instanceof LongExp) {
                LongExp exp = (LongExp)valueExp;
                return this.builder.buildLong(exp.val, info.type);
            }
            if (valueExp instanceof IntegerExp) {
                IntegerExp exp = (IntegerExp)valueExp;
                Long n = exp.val.longValue();
                return this.builder.buildLong(n, info.type);
            }
            this.wrongTypeError(valueExp, typeName, "long");
            return null;
        }
        if (this.isType("boolean", typeName, info)) {
            if (!(valueExp instanceof BooleanExp)) {
                this.wrongTypeError(valueExp, typeName, "boolean");
                return null;
            }
            BooleanExp exp = (BooleanExp)valueExp;
            return this.builder.buildBoolean(exp.val, info.type);
        }
        if (this.isType("number", typeName, info)) {
            if (valueExp instanceof NumberExp) {
                NumberExp exp = (NumberExp)valueExp;
                return this.builder.buildNumber(exp.val, info.type);
            }
            if (valueExp instanceof LongExp) {
                LongExp exp = (LongExp)valueExp;
                return this.builder.buildNumber(exp.val.doubleValue(), info.type);
            }
            if (valueExp instanceof IntegerExp) {
                IntegerExp exp = (IntegerExp)valueExp;
                return this.builder.buildNumber(exp.val.doubleValue(), info.type);
            }
            this.wrongTypeError(valueExp, typeName, "number");
            return null;
        }
        if (this.isType("date", typeName, info)) {
            return this.builder.buildDate(valueExp.strValue(), info.type);
        }
        if (this.isType("string", typeName, info)) {
            return this.builder.buildString(valueExp.strValue(), info.type);
        }
        if (valueExp instanceof NullExp) {
            return null;
        }
        return this.builder.buildString(valueExp.strValue(), info.type);
    }

    private void wrongTypeError(Exp valueExp, String typeName, String expectedType) {
        String msg = String.format("%s value is not an %s - %s", typeName, expectedType, valueExp.strValue());
        this.et.add("wrong-type", msg);
    }

    private DValue createBuilder(Exp valueExp) {
        if (valueExp instanceof IntegerExp) {
            IntegerExp exp = (IntegerExp)valueExp;
            return this.builder.buildInt(exp.val);
        }
        if (valueExp instanceof LongExp) {
            LongExp exp = (LongExp)valueExp;
            return this.builder.buildLong(exp.val);
        }
        if (valueExp instanceof BooleanExp) {
            BooleanExp exp = (BooleanExp)valueExp;
            return this.builder.buildBoolean(exp.val);
        }
        if (valueExp instanceof NumberExp) {
            NumberExp exp = (NumberExp)valueExp;
            return this.builder.buildNumber(exp.val);
        }
        if (valueExp instanceof NullExp) {
            return null;
        }
        return this.builder.buildString(valueExp.strValue());
    }

    private boolean isType(String s, String typeName, TypeInfo info) {
        DType type;
        if (typeName == null) {
            return false;
        }
        if (s.equals(typeName)) {
            BuiltInTypes bitype = BuiltInTypes.fromDeliaTypeName(s);
            info.type = this.registry.getType(bitype);
            return true;
        }
        if (BuiltInTypes.isBuiltInScalarType(typeName)) {
            BuiltInTypes bitype = BuiltInTypes.fromDeliaTypeName(s);
            info.type = this.registry.getType(bitype);
            return false;
        }
        info.type = type = this.registry.getType(typeName);
        BuiltInTypes bitype = BuiltInTypes.fromDeliaTypeName(s);
        Shape shape = BuiltInTypes.getShapeOf(bitype);
        return type.isShape(shape);
    }

    private static class TypeInfo {
        DType type;

        private TypeInfo() {
        }
    }
}

