/*
 * Decompiled with CFR 0.152.
 */
package org.delia.runner;

import java.util.List;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.TypeStatementExp;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.error.DeliaError;
import org.delia.runner.ResultValue;
import org.delia.runner.RulePostProcessor;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.typebuilder.FutureDeclError;
import org.delia.typebuilder.TypeBuilder;

public class TypeRunner
extends ServiceBase {
    private DTypeRegistry registry;
    private TypeBuilder typeBuilder;

    public TypeRunner(FactoryService factorySvc, DTypeRegistry registry) {
        super(factorySvc);
        this.registry = registry;
        this.typeBuilder = new TypeBuilder(factorySvc, registry);
    }

    public void executeStatements(List<Exp> extL, List<DeliaError> allErrors) {
        for (Exp exp : extL) {
            ResultValue res = this.executeStatement(exp);
            if (res.ok) continue;
            allErrors.addAll(res.errors);
        }
        if (allErrors.isEmpty()) {
            RulePostProcessor postProcessor = new RulePostProcessor(this.factorySvc);
            postProcessor.process(this.registry, allErrors);
        }
    }

    private ResultValue executeStatement(Exp exp) {
        ResultValue res = new ResultValue();
        if (exp instanceof TypeStatementExp) {
            this.executeTypeStatement((TypeStatementExp)exp, res);
        }
        return res;
    }

    private void executeTypeStatement(TypeStatementExp exp, ResultValue res) {
        DType dtype = this.typeBuilder.createType(exp);
        boolean bl = res.ok = dtype != null;
        if (!res.ok) {
            res.errors.addAll(this.typeBuilder.getErrorTracker().getErrors());
        }
    }

    public DTypeRegistry getRegistry() {
        return this.registry;
    }

    public boolean hasFutureDeclErrors() {
        for (DeliaError err : this.et.getErrors()) {
            if (!(err instanceof FutureDeclError)) continue;
            return true;
        }
        return false;
    }
}

