/*
 * Decompiled with CFR 0.152.
 */
package org.delia.sort.topo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.delia.relation.RelationCardinality;
import org.delia.relation.RelationInfo;
import org.delia.rule.DRule;
import org.delia.rule.DRuleBase;
import org.delia.rule.rules.RelationManyRule;
import org.delia.rule.rules.RelationOneRule;
import org.delia.sort.topo.DirectedGraph;
import org.delia.sort.topo.TopologicalSort;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.type.TypePair;
import org.delia.util.DRuleHelper;

public class DeliaTypeSorter {
    public List<String> topoSort(DTypeRegistry registry) {
        List<DStructType> typeL = this.getStructs(registry);
        DirectedGraph<String> graph = new DirectedGraph<String>();
        HashSet<DType> extset = new HashSet<DType>();
        for (DType dType : typeL) {
            DStructType structType = (DStructType)dType;
            graph.addNode(structType.getName());
            extset.add(structType);
            for (DRule rule : structType.getRawRules()) {
                TypePair pair;
                RelationInfo info;
                DRuleBase rr;
                if (rule instanceof RelationOneRule) {
                    rr = (RelationOneRule)rule;
                    info = rr.relInfo;
                    if (info.isParent) continue;
                    pair = this.findMatchingPair(structType, info.fieldName);
                    if (!extset.contains(pair.type)) {
                        graph.addNode(pair.type.getName());
                        extset.add(pair.type);
                    }
                    System.out.println(String.format("%s depends on %s", structType.getName(), pair.type.getName()));
                    graph.addEdge(structType.getName(), pair.type.getName());
                    continue;
                }
                if (!(rule instanceof RelationManyRule)) continue;
                rr = (RelationManyRule)rule;
                info = ((RelationManyRule)rr).relInfo;
                if (info.isParent || info.cardinality.equals((Object)RelationCardinality.MANY_TO_MANY)) continue;
                pair = this.findMatchingPair(structType, info.fieldName);
                if (!extset.contains(pair.type)) {
                    graph.addNode(pair.type.getName());
                    extset.add(pair.type);
                }
                System.out.println(String.format("%s depends on %s", structType.getName(), pair.type.getName()));
                graph.addEdge(structType.getName(), pair.type.getName());
            }
        }
        List<String> sortedL = TopologicalSort.sort(graph);
        Collections.reverse(sortedL);
        return sortedL;
    }

    private TypePair findMatchingPair(DStructType structType, String fieldName) {
        return DRuleHelper.findMatchingPair(structType, fieldName);
    }

    protected RelationOneRule findOneRule(String typeName, DTypeRegistry registry) {
        return DRuleHelper.findOneRule(typeName, registry);
    }

    private List<DStructType> getStructs(DTypeRegistry ds) {
        ArrayList<DStructType> list = new ArrayList<DStructType>();
        for (String typeName : ds.getAll()) {
            DType dtype = ds.getType(typeName);
            if (!dtype.isStructShape()) continue;
            list.add((DStructType)dtype);
        }
        return list;
    }
}

