/*
 * Decompiled with CFR 0.152.
 */
package org.delia.sprig;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.sprig.SprigService;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;
import org.delia.type.TypePair;
import org.delia.util.DValueHelper;
import org.delia.util.DeliaExceptionHelper;

public class SprigServiceImpl
extends ServiceBase
implements SprigService {
    private DTypeRegistry registry;
    private Map<String, SynthInfo> map = new ConcurrentHashMap<String, SynthInfo>();

    public SprigServiceImpl(FactoryService factorySvc, DTypeRegistry registry) {
        super(factorySvc);
        this.registry = registry;
    }

    @Override
    public void registerSyntheticId(String typeName, String syntheticIdName) {
        SynthInfo info;
        if (!this.registry.existsType(typeName)) {
            DeliaExceptionHelper.throwError("synthetic-id-unknown-type", "Cannot configure synthetic type for unknown type '%s'", typeName);
        }
        if ((info = this.map.get(typeName)) == null) {
            info = new SynthInfo();
        }
        info.synthFieldName = syntheticIdName;
        this.map.put(typeName, info);
    }

    @Override
    public DValue resolveSyntheticId(String typeName, String idValue) {
        SynthInfo info = this.map.get(typeName);
        if (info == null) {
            return null;
        }
        for (String mapKey : info.instanceMap.keySet()) {
            SynthInstanceDetails details = info.instanceMap.get(mapKey);
            if (!details.synId.asString().equals(idValue)) continue;
            return details.mostRecentInsertedPrimaryKey;
        }
        return null;
    }

    @Override
    public boolean haveEnabledFor(String typeName) {
        SynthInfo info = this.map.get(typeName);
        return info != null;
    }

    @Override
    public boolean haveEnabledFor(String typeName, String syntheticIdName) {
        SynthInfo info = this.map.get(typeName);
        if (info == null) {
            return false;
        }
        return info.synthFieldName.equals(syntheticIdName);
    }

    @Override
    public void setGeneratedId(String typeName, DValue idVal) {
        SynthInfo info = this.map.get(typeName);
        if (info != null) {
            // empty if block
        }
    }

    @Override
    public void rememberSynthId(String typeName, DValue dval, DValue generatedId, Map<String, DValue> extraMap) {
        SynthInfo info = this.map.get(typeName);
        if (info != null) {
            String key;
            SynthInstanceDetails details;
            DValue keyVal = generatedId;
            if (keyVal == null) {
                TypePair pair = DValueHelper.findPrimaryKeyFieldPair(dval.getType());
                keyVal = dval.asStruct().getField(pair.name);
            }
            if ((details = info.instanceMap.get(key = keyVal.asString())) == null) {
                details = new SynthInstanceDetails();
                info.instanceMap.put(key, details);
            }
            details.mostRecentInsertedPrimaryKey = keyVal;
            details.synId = extraMap.get(info.synthFieldName);
        }
    }

    public static class SynthInfo {
        public String synthFieldName;
        public Map<String, SynthInstanceDetails> instanceMap = new ConcurrentHashMap<String, SynthInstanceDetails>();
    }

    public static class SynthInstanceDetails {
        public DValue mostRecentInsertedPrimaryKey;
        public DValue synId;
    }
}

