/*
 * Decompiled with CFR 0.152.
 */
package org.delia.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.delia.type.DType;
import org.delia.type.OrderedMap;
import org.delia.type.Shape;
import org.delia.type.TypePair;

public class DStructType
extends DType {
    private OrderedMap orderedMap;
    private List<TypePair> allFields;

    public DStructType(Shape shape, String name, DType baseType, OrderedMap orderedMap) {
        super(shape, name, baseType);
        this.orderedMap = orderedMap;
    }

    public boolean fieldIsOptional(String fieldname) {
        boolean b = this.orderedMap.isOptional(fieldname);
        if (b) {
            return true;
        }
        DStructType baseType = (DStructType)this.getBaseType();
        while (baseType != null) {
            b = baseType.orderedMap.isOptional(fieldname);
            if (b) {
                return true;
            }
            baseType = (DStructType)baseType.getBaseType();
        }
        return false;
    }

    public boolean fieldIsUnique(String fieldname) {
        boolean b = this.orderedMap.isUnique(fieldname);
        if (b) {
            return true;
        }
        DStructType baseType = (DStructType)this.getBaseType();
        while (baseType != null) {
            b = baseType.orderedMap.isUnique(fieldname);
            if (b) {
                return true;
            }
            baseType = (DStructType)baseType.getBaseType();
        }
        return false;
    }

    public boolean fieldIsPrimaryKey(String fieldname) {
        boolean b = this.orderedMap.isPrimaryKey(fieldname);
        if (b) {
            return true;
        }
        DStructType baseType = (DStructType)this.getBaseType();
        while (baseType != null) {
            b = baseType.orderedMap.isPrimaryKey(fieldname);
            if (b) {
                return true;
            }
            baseType = (DStructType)baseType.getBaseType();
        }
        return false;
    }

    public boolean fieldIsSerial(String fieldname) {
        boolean b = this.orderedMap.isSerial(fieldname);
        if (b) {
            return true;
        }
        DStructType baseType = (DStructType)this.getBaseType();
        while (baseType != null) {
            b = baseType.orderedMap.isSerial(fieldname);
            if (b) {
                return true;
            }
            baseType = (DStructType)baseType.getBaseType();
        }
        return false;
    }

    public Map<String, DType> getDeclaredFields() {
        return this.orderedMap.map;
    }

    public List<String> orderedList() {
        return this.orderedMap.orderedList;
    }

    public List<TypePair> getAllFields() {
        if (this.allFields == null) {
            this.allFields = this.doAllFieldsForType(this);
        }
        return this.allFields;
    }

    private List<TypePair> doAllFieldsForType(DStructType dtype) {
        DStructType baseType = (DStructType)dtype.getBaseType();
        if (baseType == null) {
            ArrayList<TypePair> list = new ArrayList<TypePair>();
            for (String fieldName : dtype.orderedList()) {
                DType field = dtype.getDeclaredFields().get(fieldName);
                list.add(new TypePair(fieldName, field));
            }
            return list;
        }
        List<TypePair> list = this.doAllFieldsForType(baseType);
        for (String fieldName : dtype.orderedList()) {
            DType field = dtype.getDeclaredFields().get(fieldName);
            list.add(new TypePair(fieldName, field));
        }
        return list;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public void internalAdjustType(DType baseType, OrderedMap omap) {
        this.allFields = null;
        this.internalAdjustType(baseType);
        this.orderedMap = omap;
    }
}

