/*
 * Decompiled with CFR 0.152.
 */
package org.delia.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import org.delia.type.BuiltInTypes;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DTypeHierarchy;

public class DTypeRegistry {
    private Map<String, DType> map = new ConcurrentHashMap<String, DType>();
    private List<DType> orderedList = new ArrayList<DType>();
    private int nextBitIndex;
    private DTypeHierarchy th;
    private DStructType schemaVersionType;
    public static final int NUM_BUILTIN_TYPES = 7;

    public synchronized void add(String name, DType type) {
        if (type == null || name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name or type were null");
        }
        type.setBitIndex(this.nextBitIndex++);
        this.orderedList.add(type);
        this.map.put(name, type);
        this.th = null;
    }

    public synchronized DTypeHierarchy getHierarchy() {
        if (this.th == null) {
            this.th = new DTypeHierarchy();
            this.th.build(this.map);
        }
        return this.th;
    }

    public Set<String> getAll() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public boolean existsType(String name) {
        return this.getType(name) != null;
    }

    public DType getType(String name) {
        return this.map.get(name);
    }

    public DType getType(BuiltInTypes builtInType) {
        return this.map.get(builtInType.name());
    }

    public List<DType> getChildTypes(DType type) {
        DTypeHierarchy th = this.getHierarchy();
        return th.findChildTypes(this.map, type);
    }

    public List<DType> getParentTypes(DType type) {
        DTypeHierarchy th = this.getHierarchy();
        return th.findParentTypes(this.map, type);
    }

    public List<DType> getOrderedList() {
        return this.orderedList;
    }

    public void setSchemaVersionType(DStructType dtype) {
        this.schemaVersionType = dtype;
    }

    public DStructType getSchemaVersionType() {
        return this.schemaVersionType;
    }

    public DStructType findTypeOrSchemaVersionType(String typeName) {
        if (this.schemaVersionType != null && this.schemaVersionType.getName().equals(typeName)) {
            return this.schemaVersionType;
        }
        return (DStructType)this.getType(typeName);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(",");
        for (DType type : this.orderedList) {
            joiner.add(type.getName());
        }
        return joiner.toString();
    }
}

