/*
 * Decompiled with CFR 0.152.
 */
package org.delia.type;

import java.util.Date;
import java.util.Map;
import org.delia.type.DRelation;
import org.delia.type.DStructHelper;
import org.delia.type.DType;
import org.delia.type.DValue;
import org.delia.type.DValueInternal;
import org.delia.type.ValidationState;
import org.delia.type.WrappedDate;

public class DValueImpl
implements DValue,
DValueInternal {
    private DType type;
    private Object object;
    private ValidationState valState = ValidationState.UNKNOWN;
    private Object persistenceId;

    public DValueImpl(DType type, Object object) {
        this.type = type;
        this.object = object;
    }

    @Override
    public DType getType() {
        return this.type;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public ValidationState getValidationState() {
        return this.valState;
    }

    @Override
    public boolean isValid() {
        return this.valState == ValidationState.VALID;
    }

    @Override
    public void setValidationState(ValidationState valState) {
        this.valState = valState;
    }

    public void forceObject(Object obj) {
        this.object = obj;
    }

    public void forceType(DType type) {
        this.type = type;
    }

    @Override
    public int asInt() {
        if (this.object instanceof Integer) {
            Integer lval = (Integer)this.object;
            return lval;
        }
        Long lval = (Long)this.object;
        return lval.intValue();
    }

    @Override
    public double asNumber() {
        if (this.object instanceof Integer) {
            Integer lval = (Integer)this.object;
            return lval.doubleValue();
        }
        if (this.object instanceof Long) {
            Long lval = (Long)this.object;
            return lval.doubleValue();
        }
        Double lval = (Double)this.object;
        return lval;
    }

    @Override
    public long asLong() {
        if (this.object instanceof Integer) {
            Integer lval = (Integer)this.object;
            return lval.longValue();
        }
        Long lval = (Long)this.object;
        return lval;
    }

    @Override
    public String asString() {
        if (this.object instanceof WrappedDate) {
            WrappedDate wdt = (WrappedDate)this.object;
            return wdt.asString();
        }
        return this.object.toString();
    }

    @Override
    public boolean asBoolean() {
        Boolean bool = (Boolean)this.object;
        return bool;
    }

    @Override
    public Date asDate() {
        WrappedDate wdt = (WrappedDate)this.object;
        Date dt = wdt.getDate();
        return dt;
    }

    @Override
    public Map<String, DValue> asMap() {
        return (Map)this.object;
    }

    @Override
    public DStructHelper asStruct() {
        return new DStructHelper(this);
    }

    @Override
    public Object getPersistenceId() {
        return this.persistenceId;
    }

    @Override
    public void setPersistenceId(Object persistenceId) {
        this.persistenceId = persistenceId;
    }

    @Override
    public DRelation asRelation() {
        DRelation drel = (DRelation)this.object;
        return drel;
    }

    public String toString() {
        String s = "";
        if (this.object != null && this.type.isNumericShape()) {
            s = ": " + this.object.toString();
        }
        return this.type.toString() + s;
    }
}

