/*
 * Decompiled with CFR 0.152.
 */
package org.delia.typebuilder;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.delia.compiler.ast.IntegerExp;
import org.delia.compiler.ast.StringExp;
import org.delia.compiler.astx.XNAFMultiExp;
import org.delia.compiler.astx.XNAFSingleExp;
import org.delia.core.FactoryService;
import org.delia.rule.AlwaysRuleGuard;
import org.delia.rule.DRule;
import org.delia.rule.DRuleBase;
import org.delia.rule.DValueRuleOperand;
import org.delia.rule.NotNullGuard;
import org.delia.rule.RuleGuard;
import org.delia.rule.RuleOperand;
import org.delia.rule.StructDValueRuleOperand;
import org.delia.rule.fns.DateMakeFnRule;
import org.delia.rule.fns.DateYearFnRule;
import org.delia.rule.fns.LenFnRule;
import org.delia.rule.rules.ContainsRule;
import org.delia.rule.rules.MaxLenRule;

public class RuleFuncFactory {
    private FactoryService factorySvc;

    public RuleFuncFactory(FactoryService factorySvc) {
        this.factorySvc = factorySvc;
    }

    public DRule createRule(XNAFMultiExp rfe, int index) {
        XNAFSingleExp qfe0;
        XNAFSingleExp qfe = qfe0 = rfe.qfeL.get(index);
        String fieldName = null;
        if (rfe.qfeL.size() == 2) {
            XNAFSingleExp qfe1 = rfe.qfeL.get(1);
            if (!qfe0.isRuleFn && qfe1.isRuleFn) {
                fieldName = qfe0.funcName;
                qfe = qfe1;
            }
        }
        DRuleBase rule = null;
        RuleGuard guard = new AlwaysRuleGuard();
        switch (qfe.funcName) {
            case "contains": {
                StringExp arg = (StringExp)qfe.argL.get(0);
                RuleOperand oper = this.createOperand(fieldName);
                guard = this.adjustGuard(oper, guard);
                rule = new ContainsRule(guard, oper, arg.strValue());
                break;
            }
            case "maxlen": {
                IntegerExp arg = (IntegerExp)qfe.argL.get(0);
                RuleOperand oper = this.createOperand(fieldName);
                guard = this.adjustGuard(oper, guard);
                rule = new MaxLenRule(guard, oper, arg.val);
                break;
            }
            case "len": {
                rule = new LenFnRule(guard);
                break;
            }
            case "year": {
                rule = new DateYearFnRule(guard);
                break;
            }
            case "date": {
                if (qfe.argL.isEmpty()) break;
                rule = new DateMakeFnRule(this.factorySvc, guard, qfe.argL.get(0));
                break;
            }
        }
        if (rule != null) {
            rule.setPolarity(rfe.polarity);
        }
        return rule;
    }

    private RuleGuard adjustGuard(RuleOperand oper, RuleGuard guard) {
        List<String> fieldL = oper.getFieldList();
        if (CollectionUtils.isNotEmpty(fieldL)) {
            return new NotNullGuard(fieldL);
        }
        return guard;
    }

    private RuleOperand createOperand(String fieldName) {
        if (fieldName == null) {
            return new DValueRuleOperand();
        }
        return new StructDValueRuleOperand(fieldName);
    }
}

