/*
 * Decompiled with CFR 0.152.
 */
package org.delia.util;

import org.delia.relation.RelationCardinality;
import org.delia.relation.RelationInfo;
import org.delia.rule.DRule;
import org.delia.rule.DRuleBase;
import org.delia.rule.rules.RelationManyRule;
import org.delia.rule.rules.RelationOneRule;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.type.TypePair;

public class DRuleHelper {
    public static TypePair findMatchingPair(DStructType structType, String fieldName) {
        for (TypePair pair : structType.getAllFields()) {
            if (!pair.type.isStructShape() || !fieldName.equals(pair.name)) continue;
            return pair;
        }
        return null;
    }

    public static TypePair findMatchingRelByType(DStructType dtype, DType targetType) {
        for (TypePair pair : dtype.getAllFields()) {
            if (!pair.type.getName().contentEquals(targetType.getName())) continue;
            return pair;
        }
        return null;
    }

    public static boolean isParentRelation(DStructType structType, TypePair pair) {
        RelationInfo info = DRuleHelper.findMatchingRuleInfo(structType, pair);
        return info != null && info.isParent;
    }

    public static RelationInfo findMatchingRuleInfo(DStructType structType, TypePair pair) {
        for (DRule rule : structType.getRawRules()) {
            DRuleBase rr;
            if (rule instanceof RelationOneRule) {
                rr = (RelationOneRule)rule;
                if (!rr.relInfo.fieldName.equals(pair.name)) continue;
                return rr.relInfo;
            }
            if (!(rule instanceof RelationManyRule)) continue;
            rr = (RelationManyRule)rule;
            if (!((RelationManyRule)rr).relInfo.fieldName.equals(pair.name)) continue;
            return ((RelationManyRule)rr).relInfo;
        }
        return null;
    }

    public static RelationOneRule findOneRule(String typeName, DTypeRegistry registry) {
        DStructType dtype = (DStructType)registry.getType(typeName);
        for (DRule rule : dtype.getRawRules()) {
            if (!(rule instanceof RelationOneRule)) continue;
            return (RelationOneRule)rule;
        }
        return null;
    }

    public static RelationManyRule findManyRule(String typeName, DTypeRegistry registry) {
        DStructType dtype = (DStructType)registry.getType(typeName);
        for (DRule rule : dtype.getRawRules()) {
            if (!(rule instanceof RelationManyRule)) continue;
            return (RelationManyRule)rule;
        }
        return null;
    }

    public static boolean isOtherSideOne(DType otherSide, DStructType structType) {
        RelationInfo info = DRuleHelper.findOtherSideOne(otherSide, structType);
        return info != null;
    }

    public static RelationInfo findOtherSideOne(DType otherSide, DStructType structType) {
        for (DRule rule : otherSide.getRawRules()) {
            if (!(rule instanceof RelationOneRule)) continue;
            RelationOneRule rr = (RelationOneRule)rule;
            if (!rr.relInfo.farType.equals(structType)) continue;
            return rr.relInfo;
        }
        return null;
    }

    public static RelationInfo findOtherSideMany(DType otherSide, DStructType structType) {
        for (DRule rule : otherSide.getRawRules()) {
            if (!(rule instanceof RelationManyRule)) continue;
            RelationManyRule rr = (RelationManyRule)rule;
            if (!rr.relInfo.farType.equals(structType)) continue;
            return rr.relInfo;
        }
        return null;
    }

    public static RelationInfo findOtherSideOneOrMany(DType otherSide, DStructType structType) {
        RelationInfo farInfo = DRuleHelper.findOtherSideOne(otherSide, structType);
        if (farInfo == null) {
            farInfo = DRuleHelper.findOtherSideMany(otherSide, structType);
        }
        return farInfo;
    }

    public static RelationInfo findOtherSideOneOrManyForField(DType structType, String fieldName) {
        for (DRule rule : structType.getRawRules()) {
            DRuleBase rr;
            if (rule instanceof RelationOneRule) {
                rr = (RelationOneRule)rule;
                if (!rr.relInfo.fieldName.equals(fieldName)) continue;
                return rr.relInfo;
            }
            if (!(rule instanceof RelationManyRule)) continue;
            rr = (RelationManyRule)rule;
            if (!((RelationManyRule)rr).relInfo.fieldName.equals(fieldName)) continue;
            return ((RelationManyRule)rr).relInfo;
        }
        return null;
    }

    public static boolean isOtherSideMany(DType otherSide, TypePair otherRelPair) {
        for (DRule rule : otherSide.getRawRules()) {
            if (!otherRelPair.name.contentEquals(rule.getSubject())) continue;
            return rule instanceof RelationManyRule;
        }
        return false;
    }

    public static boolean isManyToManyRelation(TypePair pair, DStructType dtype) {
        if (!dtype.isStructShape()) {
            return false;
        }
        RelationInfo info = DRuleHelper.findMatchingRuleInfo(dtype, pair);
        return info != null && info.cardinality.equals((Object)RelationCardinality.MANY_TO_MANY);
    }

    public static RelationInfo findManyToManyRelation(TypePair pair, DStructType dtype) {
        if (!dtype.isStructShape()) {
            return null;
        }
        RelationInfo info = DRuleHelper.findMatchingRuleInfo(dtype, pair);
        if (info != null && info.cardinality.equals((Object)RelationCardinality.MANY_TO_MANY)) {
            return info;
        }
        return null;
    }
}

