/*
 * Decompiled with CFR 0.152.
 */
package org.delia.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class TextFileReader {
    public String readFileAsSingleString(String path) {
        List<String> lines = this.readFile(path);
        String lf = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        for (String s : lines) {
            sb.append(s);
            sb.append(lf);
        }
        return sb.toString();
    }

    public List<String> readFile(String path) {
        try {
            FileReader reader = new FileReader(path);
            return this.doReadFile(reader);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> ReadFileStream(InputStream istr) throws IOException {
        InputStreamReader reader = new InputStreamReader(istr);
        return this.doReadFile(reader);
    }

    private List<String> doReadFile(Reader inReader) throws IOException {
        ArrayList<String> linesL = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(inReader);){
            StringBuilder builder = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                builder.append(line);
                builder.append(System.lineSeparator());
                linesL.add(line);
                line = reader.readLine();
            }
        }
        return linesL;
    }
}

