/*
 * Decompiled with CFR 0.152.
 */
package org.delia.valuebuilder;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.delia.type.BuiltInTypes;
import org.delia.type.DRelation;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;
import org.delia.type.DValueImpl;
import org.delia.type.Shape;
import org.delia.type.TypePair;
import org.delia.util.DValueHelper;
import org.delia.util.DeliaExceptionHelper;
import org.delia.valuebuilder.DValueBuilder;

public class RelationValueBuilder
extends DValueBuilder {
    private String foreignTypeName;
    private DTypeRegistry registry;
    private DType idType;

    public RelationValueBuilder(DType type, String foreignTypeName, DTypeRegistry registry) {
        if (!type.isShape(Shape.RELATION)) {
            this.addWrongTypeError("expecting relation");
            return;
        }
        this.type = type;
        this.foreignTypeName = foreignTypeName;
        this.registry = registry;
        DType idType = registry.getType(foreignTypeName);
        TypePair pair = DValueHelper.findPrimaryKeyFieldPair(idType);
        this.idType = pair.type;
    }

    @Override
    public void buildFromString(String input) {
        if (input == null) {
            this.addNoDataError("no data");
            return;
        }
        if (this.idType.isShape(Shape.INTEGER)) {
            this.doInt(input);
        } else if (this.idType.isShape(Shape.LONG)) {
            this.doLong(input);
        } else if (this.idType.isShape(Shape.STRING)) {
            this.doString(input);
        } else {
            DeliaExceptionHelper.throwError("unsupported-relation-key-type", "Relations with primary key '%s' not supporte", this.idType.getShape().name());
        }
    }

    private void doInt(String input) {
        Integer nval = null;
        try {
            nval = Integer.parseInt(input);
            nval = (int)nval;
            DType keyType = this.registry.getType(BuiltInTypes.INTEGER_SHAPE);
            this.setNewDVal(keyType, nval);
        }
        catch (NumberFormatException e) {
            this.addParsingError(String.format("'%s' is not an integer", input), input);
        }
    }

    private void doLong(String input) {
        Long nval = null;
        try {
            nval = Long.parseLong(input);
            nval = (long)nval;
            DType keyType = this.registry.getType(BuiltInTypes.LONG_SHAPE);
            this.setNewDVal(keyType, nval);
        }
        catch (NumberFormatException e) {
            this.addParsingError(String.format("'%s' is not an long", input), input);
        }
    }

    private void doString(String input) {
        try {
            DType keyType = this.registry.getType(BuiltInTypes.STRING_SHAPE);
            this.setNewDVal(keyType, input);
        }
        catch (NumberFormatException e) {
            this.addParsingError(String.format("'%s' is not an string", input), input);
        }
    }

    private void setNewDVal(DType keyType, Object nval) {
        DValueImpl keyVal = new DValueImpl(keyType, nval);
        DRelation dvalrel = new DRelation(this.foreignTypeName, keyVal);
        this.newDVal = new DValueImpl(this.type, dvalrel);
    }

    public void buildFromList(List<DValue> elementL) {
        if (CollectionUtils.isEmpty(elementL)) {
            this.addNoDataError("no data");
            return;
        }
        DRelation dvalrel = new DRelation(this.foreignTypeName, elementL);
        this.newDVal = new DValueImpl(this.type, dvalrel);
    }

    @Override
    protected void onFinish() {
    }
}

