/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncInputStream {
    private static final int BUFFER_SIZE = 4096;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InputStream input;
    private final String name;
    private final Listener listener;
    private boolean closed;

    public AsyncInputStream(InputStream input, String name, Listener listener) {
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        if (name == null) {
            throw new IllegalArgumentException("name input");
        }
        this.input = input;
        this.name = name;
        this.listener = listener;
        new Thread(this.name){

            @Override
            public void run() {
                AsyncInputStream.this.threadMain();
            }
        }.start();
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        try {
            this.input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadMain() {
        try {
            this.runLoop();
        }
        catch (Throwable t) {
            AsyncInputStream asyncInputStream = this;
            synchronized (asyncInputStream) {
                if (this.closed) {
                    return;
                }
            }
            try {
                if (this.listener != null) {
                    this.listener.handleException(t);
                }
            }
            catch (Exception e) {
                this.log.error(this.name + ": caught unexpected exception", (Throwable)e);
            }
        }
    }

    private void runLoop() throws IOException {
        byte[] buf = new byte[4096];
        while (true) {
            int r;
            if ((r = this.input.read(buf)) == -1) {
                if (this.listener == null) break;
                this.listener.handleEOF();
                break;
            }
            if (this.listener == null) continue;
            this.listener.handleInput(buf, 0, r);
        }
    }

    public static interface Listener {
        public void handleInput(byte[] var1, int var2, int var3);

        public void handleException(Throwable var1);

        public void handleEOF();
    }
}

