/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class AtomicUpdateFileOutputStream
extends FileOutputStream {
    public static final int OPEN = 0;
    public static final int CLOSED = 1;
    public static final int CANCELED = 2;
    private final File targetFile;
    private final File tempFile;
    private int state;
    private long timestamp;
    private boolean invokingSuperClose;

    public AtomicUpdateFileOutputStream(File targetFile, File tempFile) throws FileNotFoundException {
        this(targetFile, tempFile, false);
    }

    public AtomicUpdateFileOutputStream(File targetFile, File tempFile, boolean append) throws FileNotFoundException {
        super(tempFile, append);
        this.tempFile = tempFile;
        if (targetFile == null) {
            throw new NullPointerException("null targetFile");
        }
        this.targetFile = targetFile;
    }

    public AtomicUpdateFileOutputStream(File targetFile) throws IOException {
        this(targetFile, false);
    }

    public AtomicUpdateFileOutputStream(File targetFile, boolean append) throws IOException {
        this(targetFile, AtomicUpdateFileOutputStream.tempFileFor(targetFile), append);
    }

    private static File tempFileFor(File targetFile) throws IOException {
        return File.createTempFile("atomicupdate", null, targetFile.getAbsoluteFile().getParentFile());
    }

    public synchronized File getTargetFile() {
        return this.targetFile;
    }

    public synchronized File getTempFile() {
        return this.tempFile;
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized boolean cancel() {
        if (this.state != 0) {
            return false;
        }
        this.state = 2;
        if (!this.invokingSuperClose) {
            try {
                super.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.invokingSuperClose = false;
            }
        }
        this.tempFile.delete();
        return true;
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            super.write(b);
        }
        catch (IOException e) {
            this.cancel();
            throw e;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            super.write(b, off, len);
        }
        catch (IOException e) {
            this.cancel();
            throw e;
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            super.write(b);
        }
        catch (IOException e) {
            this.cancel();
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            super.flush();
        }
        catch (IOException e) {
            this.cancel();
            throw e;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.invokingSuperClose) {
            super.close();
            return;
        }
        switch (this.state) {
            case 1: 
            case 2: {
                return;
            }
        }
        try {
            this.invokingSuperClose = true;
            try {
                super.close();
            }
            finally {
                this.invokingSuperClose = false;
            }
            long newTimestamp = this.tempFile.lastModified();
            Files.move(this.tempFile.toPath(), this.targetFile.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            this.timestamp = newTimestamp;
        }
        catch (IOException e) {
            this.cancel();
            throw e;
        }
        this.state = 1;
    }

    public synchronized long getTimestamp() {
        return this.timestamp;
    }

    protected void finalize() throws IOException {
        try {
            this.cancel();
        }
        finally {
            super.finalize();
        }
    }
}

