/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.dellroad.stuff.string.ByteArrayEncoder;

public enum BOM {
    UTF_8("efbbbf"),
    UTF_16BE("feff"),
    UTF_16LE("fffe"),
    UTF_32BE("0000feff"),
    UTF_32LE("fffe0000"),
    GB18030("84319533");

    private final byte[] bytes;

    private BOM(String bytes) {
        this.bytes = ByteArrayEncoder.decode(bytes);
    }

    public byte[] getSignature() {
        return (byte[])this.bytes.clone();
    }

    public Charset getCharset() {
        try {
            return Charset.forName(this.name().replace('_', '-'));
        }
        catch (UnsupportedCharsetException e) {
            throw new RuntimeException("unexpected error", e);
        }
    }
}

