/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Optional;
import org.dellroad.stuff.io.BOM;

public class BOMReader
extends Reader {
    static final int BUFFER_SIZE = 4080;
    private static final int MAX_BOM_LENGTH = 16;
    private final BufferedInputStream input;
    private final CodingErrorAction errorAction;
    private final Charset defaultCharset;
    private InputStreamReader reader;
    private BOM bom;

    public BOMReader(InputStream input) {
        this(input, CodingErrorAction.REPORT, Charset.defaultCharset());
    }

    public BOMReader(InputStream input, CodingErrorAction errorAction, Charset defaultCharset) {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"null input");
        Preconditions.checkArgument((errorAction != null ? 1 : 0) != 0, (Object)"null errorAction");
        Preconditions.checkArgument((defaultCharset != null ? 1 : 0) != 0, (Object)"null defaultCharset");
        this.input = new BufferedInputStream(input, 4080);
        this.errorAction = errorAction;
        this.defaultCharset = defaultCharset;
        this.input.mark(16);
    }

    public BOM getBOM() throws IOException {
        this.getReader();
        return this.bom;
    }

    public Charset getCharset() throws IOException {
        this.getReader();
        return this.deriveCharset();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        } else {
            this.input.close();
        }
    }

    @Override
    public void mark(int limit) throws IOException {
        this.getReader().mark(limit);
    }

    @Override
    public int read() throws IOException {
        return this.getReader().read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.getReader().read(cbuf);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.getReader().read(cbuf, off, len);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        return this.getReader().read(target);
    }

    @Override
    public boolean ready() throws IOException {
        return this.getReader().ready();
    }

    @Override
    public void reset() throws IOException {
        this.getReader().reset();
    }

    @Override
    public long skip(long num) throws IOException {
        return this.getReader().skip(num);
    }

    private Reader getReader() throws IOException {
        int r;
        if (this.reader != null) {
            return this.reader;
        }
        assert (this.bom == null);
        EnumSet<BOM> remainingBOMs = EnumSet.allOf(BOM.class);
        int bytesRead = 0;
        while ((r = this.input.read()) != -1) {
            byte nextByte = (byte)r;
            ++bytesRead;
            Iterator i = remainingBOMs.iterator();
            while (i.hasNext()) {
                BOM remainingBOM = (BOM)((Object)i.next());
                byte[] bytes = remainingBOM.getSignature();
                if (bytes[bytesRead - 1] != nextByte) {
                    i.remove();
                    continue;
                }
                if (bytesRead != bytes.length) continue;
                this.bom = remainingBOM;
                break;
            }
            if (this.bom == null && !remainingBOMs.isEmpty()) continue;
        }
        if (this.bom == null) {
            this.input.reset();
        }
        CharsetDecoder decoder = this.deriveCharset().newDecoder().onMalformedInput(this.errorAction);
        this.reader = new InputStreamReader((InputStream)this.input, decoder);
        return this.reader;
    }

    private Charset deriveCharset() {
        return Optional.ofNullable(this.bom).map(BOM::getCharset).orElse(this.defaultCharset);
    }
}

