/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicLong;

public class BitwiseInputStream
extends FilterInputStream {
    private byte bufBits;
    private byte bufLen;
    private byte markBits;
    private byte markLen;

    public BitwiseInputStream(InputStream in) {
        super(in);
    }

    @Override
    public void close() throws IOException {
        assert (this.invariants());
        this.bufBits = 0;
        this.bufLen = 0;
        super.close();
    }

    @Override
    public void mark(int readlimit) {
        assert (this.invariants());
        super.mark(readlimit);
        this.markBits = this.bufBits;
        this.markLen = this.bufLen;
    }

    @Override
    public void reset() throws IOException {
        assert (this.invariants());
        super.reset();
        this.bufBits = this.markBits;
        this.bufLen = this.markLen;
    }

    @Override
    public int read() throws IOException {
        assert (this.invariants());
        if (this.bufLen == 0) {
            return this.in.read();
        }
        int next = this.in.read();
        if (next == -1) {
            return next;
        }
        int r = (this.bufBits | next << this.bufLen) & 0xFF;
        this.bufBits = (byte)(next >> 8 - this.bufLen);
        assert (this.invariants());
        return r;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        assert (this.invariants());
        if (this.bufLen == 0 || len == 0) {
            return this.in.read(buf, off, len);
        }
        if (off < 0 || len < 0 || (long)off + (long)len > (long)buf.length) {
            throw new IndexOutOfBoundsException();
        }
        int r = this.in.read(buf, off, len);
        if (r == -1) {
            return -1;
        }
        this.bufBits = BitwiseInputStream.shiftInBits(this.bufBits, this.bufLen, buf, off, r);
        assert (this.invariants());
        return r;
    }

    @Override
    public long skip(long remain) throws IOException {
        int r;
        assert (this.invariants());
        if (this.bufLen == 0) {
            return super.skip(remain);
        }
        long skipped = 0L;
        byte[] buf = new byte[(int)Math.min(1024L, remain)];
        while (remain > 0L && (r = this.read(buf, 0, (int)Math.min(remain, (long)buf.length))) != -1) {
            skipped += (long)r;
            remain -= (long)r;
        }
        assert (this.invariants());
        return skipped;
    }

    public BitSet readBits(int len) throws IOException {
        int r;
        assert (this.invariants());
        if (len < 0) {
            throw new IllegalArgumentException("len = " + len);
        }
        int numBytes = len / 8;
        int numBits = len % 8;
        byte[] buf = new byte[numBytes + (numBits > 0 ? 1 : 0)];
        for (int off = 0; off < numBytes; off += r) {
            r = this.read(buf, off, numBytes - off);
            if (r != -1) continue;
            throw new EOFException();
        }
        if (numBits > 0) {
            buf[numBytes] = (byte)this.bits(numBits);
        }
        assert (this.invariants());
        return BitSet.valueOf(buf);
    }

    public int readBits(AtomicLong result, int len) throws IOException {
        assert (this.invariants());
        if (len < 0 || len > 64) {
            throw new IllegalArgumentException("len = " + len);
        }
        int count = 0;
        long value = 0L;
        while (len > 0) {
            if (this.bufLen == 0) {
                int r = this.in.read();
                if (r == -1) {
                    if (count != 0) break;
                    return -1;
                }
                this.bufBits = (byte)r;
                this.bufLen = (byte)8;
            }
            int numCopy = Math.min(len, this.bufLen);
            assert (numCopy > 0);
            long mask = (1L << numCopy) - 1L;
            value |= ((long)this.bufBits & mask) << count;
            this.bufBits = (byte)((this.bufBits & 0xFF) >>> numCopy);
            this.bufLen = (byte)(this.bufLen - numCopy);
            count += numCopy;
            len -= numCopy;
        }
        if (count < 64) {
            value &= -1L << count ^ 0xFFFFFFFFFFFFFFFFL;
        }
        result.set(value);
        assert (this.invariants());
        return count;
    }

    public long bits(int len) throws IOException {
        AtomicLong word = new AtomicLong();
        int r = this.readBits(word, len);
        if (r < len) {
            throw new EOFException();
        }
        return word.get();
    }

    public boolean bit() throws IOException {
        switch (this.readBit()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new EOFException();
    }

    public int readBit() throws IOException {
        AtomicLong word = new AtomicLong();
        int r = this.readBits(word, 1);
        return r == -1 ? -1 : (int)word.get() & 1;
    }

    public int bitOffset() {
        assert (this.invariants());
        return this.bufLen & 7;
    }

    public int skipToByteBoundary() throws IOException {
        assert (this.invariants());
        byte skipped = this.bufLen;
        this.bufBits = 0;
        this.bufLen = 0;
        return skipped;
    }

    static byte shiftInBits(byte byteBits, int nbits, byte[] buf, int off, int len) {
        int bits = byteBits & 0xFF;
        assert ((bits & -1 << nbits) == 0);
        assert (nbits > 0 && nbits < 8);
        while (len-- > 0) {
            int value16 = (buf[off] & 0xFF) << nbits | bits;
            buf[off] = (byte)value16;
            bits = value16 >>> 8;
            ++off;
        }
        return (byte)bits;
    }

    String describe() {
        return String.format("bits=0x%02x,len=%d", this.bufBits & 0xFF, this.bufLen);
    }

    boolean invariants() {
        assert (this.bufLen >= 0 && this.bufLen < 8) : this.describe();
        assert ((this.bufBits & 0xFF & -1 << this.bufLen) == 0) : this.describe();
        return true;
    }
}

