/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.BitSet;
import org.dellroad.stuff.io.BitwiseInputStream;

public class BitwiseOutputStream
extends FilterOutputStream {
    private byte bufBits;
    private byte bufLen;

    public BitwiseOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void close() throws IOException {
        this.padToByteBoundary();
        super.close();
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        assert (this.invariants());
        if (this.bufLen == 0) {
            this.out.write(buf, off, len);
            return;
        }
        if (off < 0 || len < 0 || (long)off + (long)len > (long)buf.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] copy = new byte[len];
        System.arraycopy(buf, off, copy, 0, len);
        buf = copy;
        this.bufBits = BitwiseInputStream.shiftInBits(this.bufBits, this.bufLen, buf, 0, buf.length);
        this.out.write(buf, 0, buf.length);
        assert (this.invariants());
    }

    @Override
    public void write(int b) throws IOException {
        assert (this.invariants());
        if (this.bufLen == 0) {
            this.out.write(b);
            return;
        }
        this.out.write(this.bufBits | b << this.bufLen);
        this.bufBits = (byte)((b & 0xFF) >>> 8 - this.bufLen);
        assert (this.invariants());
    }

    public void writeBits(BitSet bits, int len) throws IOException {
        assert (this.invariants());
        if (bits == null) {
            throw new IllegalArgumentException("null bits");
        }
        if (len < 0) {
            throw new IllegalArgumentException("len = " + len);
        }
        byte[] data = bits.toByteArray();
        int numBytes = Math.min(len / 8, data.length);
        int off = 0;
        if (numBytes > 0) {
            this.write(data, 0, numBytes);
            off += numBytes;
            len -= numBytes * 8;
        }
        while (len > 0) {
            int numBits = Math.min(8, len);
            byte value = off < data.length ? data[off++] : (byte)0;
            this.writeBits(value, numBits);
            len -= numBits;
        }
        assert (this.invariants());
    }

    public void writeBits(long bits, int len) throws IOException {
        assert (this.invariants());
        if (len < 0 || len > 64) {
            throw new IllegalArgumentException("len = " + len);
        }
        if (len < 64) {
            bits &= -1L << len ^ 0xFFFFFFFFFFFFFFFFL;
        }
        while (len > 0) {
            int numCopy = Math.min(len, 8 - this.bufLen);
            assert (numCopy > 0);
            this.bufBits = (byte)((long)this.bufBits | bits << this.bufLen);
            this.bufLen = (byte)(this.bufLen + numCopy);
            bits >>>= numCopy;
            len -= numCopy;
            if (this.bufLen != 8) continue;
            this.outputByte();
        }
        assert (this.invariants());
    }

    public void writeBit(boolean bit) throws IOException {
        this.writeBits(bit ? 1L : 0L, 1);
    }

    public int bitOffset() {
        return this.bufLen & 7;
    }

    public int padToByteBoundary() throws IOException {
        assert (this.invariants());
        if (this.bufLen == 0) {
            return 0;
        }
        int pad = 8 - this.bufLen;
        this.outputByte();
        assert (this.invariants());
        return pad;
    }

    private void outputByte() throws IOException {
        this.out.write(this.bufBits);
        this.bufBits = 0;
        this.bufLen = 0;
    }

    String describe() {
        return String.format("bits=0x%02x,len=%d", this.bufBits & 0xFF, this.bufLen);
    }

    boolean invariants() {
        assert (this.bufLen >= 0 && this.bufLen < 8) : this.describe();
        assert ((this.bufBits & 0xFF & -1 << this.bufLen) == 0) : this.describe();
        return true;
    }
}

