/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public class ByteBufferOutputStream
extends OutputStream {
    protected final ByteBuffer buf;
    private boolean closed;

    public ByteBufferOutputStream(ByteBuffer buf) {
        if (buf == null) {
            throw new IllegalArgumentException("null buf");
        }
        this.buf = buf;
    }

    @Override
    public synchronized void close() {
        this.closed = true;
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
    }

    @Override
    public synchronized void write(int value) throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        try {
            this.buf.put((byte)value);
        }
        catch (BufferOverflowException | ReadOnlyBufferException e) {
            throw new IOException("exception from underlying ByteBuffer", e);
        }
    }

    @Override
    public synchronized void write(byte[] data, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        try {
            this.buf.put(data, off, len);
        }
        catch (BufferOverflowException | ReadOnlyBufferException e) {
            throw new IOException("exception from underlying ByteBuffer", e);
        }
    }
}

