/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.dellroad.stuff.io.AtomicUpdateFileOutputStream;
import org.dellroad.stuff.io.StreamRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStreamRepository
implements StreamRepository,
Serializable {
    private static final long serialVersionUID = 6073048079512648449L;
    private transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final File file;
    private int numBackups;
    private long timestamp;

    public FileStreamRepository(File file, int numBackups) {
        if (file == null) {
            throw new IllegalArgumentException("null file");
        }
        if (numBackups < 0) {
            throw new IllegalArgumentException("negative numBackups");
        }
        this.file = file;
        this.numBackups = numBackups;
    }

    public FileStreamRepository(File file) {
        this(file, 0);
    }

    public final File getFile() {
        return this.file;
    }

    public final synchronized int getNumBackups() {
        return this.numBackups;
    }

    public synchronized void setNumBackups(int numBackups) {
        this.numBackups = numBackups;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public AtomicUpdateFileOutputStream getOutputStream() throws IOException {
        String tempName = this.file.getName();
        if (tempName.length() < 3) {
            tempName = tempName + "zzz".substring(tempName.length());
        }
        File tempFile = File.createTempFile(tempName, null, this.file.getAbsoluteFile().getParentFile());
        return new AtomicUpdateFileOutputStream(this.file, tempFile){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                FileStreamRepository fileStreamRepository = FileStreamRepository.this;
                synchronized (fileStreamRepository) {
                    FileStreamRepository.this.rotateBackups();
                    super.close();
                    FileStreamRepository.this.timestamp = this.getTimestamp();
                }
            }
        };
    }

    public synchronized long getFileTimestamp() {
        return this.timestamp;
    }

    protected File getBackupFile(File file, int index) {
        return new File(file.toString() + "." + index);
    }

    protected void copy(File src, File dst) throws IOException {
        Path srcPath = src.toPath();
        Path dstPath = dst.toPath();
        try {
            if (dst.exists() && Files.isSameFile(srcPath, dstPath)) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Files.createLink(dstPath, srcPath);
        }
        catch (FileAlreadyExistsException e) {
            dst.delete();
            Files.createLink(dstPath, srcPath);
        }
    }

    private synchronized void rotateBackups() throws IOException {
        int i;
        File[] files = new File[this.numBackups + 1];
        files[0] = this.getFile();
        for (i = 0; i < this.numBackups; ++i) {
            files[i + 1] = this.getBackupFile(this.getFile(), i + 1);
        }
        for (i = this.numBackups - 1; i >= 0; --i) {
            File src = files[i];
            File dst = files[i + 1];
            if (i == 0) {
                try {
                    this.copy(src, dst);
                }
                catch (IOException e) {
                    this.log.warn("failed to copy `" + src + "' to backup `" + dst + "'", (Throwable)e);
                }
                continue;
            }
            src.renameTo(dst);
        }
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

