/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.dellroad.stuff.io.NullUtil;
import org.dellroad.stuff.io.PipedStreams;
import org.dellroad.stuff.io.WriteCallback;
import org.dellroad.stuff.java.ThrowableUtil;

public class NullModemInputStream
extends FilterInputStream {
    private final AtomicReference<Throwable> error = new AtomicReference();

    public NullModemInputStream(WriteCallback writer, String threadName) {
        this(writer, NullUtil.newThreadExecutor(threadName));
    }

    public NullModemInputStream(WriteCallback writer, Executor executor) {
        super(new PipedStreams().getInputStream());
        if (writer == null) {
            throw new IllegalArgumentException("null writer");
        }
        if (executor == null) {
            throw new IllegalArgumentException("null executor");
        }
        PipedStreams.Output output = this.getPipedStreams().getOutputStream();
        executor.execute(() -> {
            try {
                writer.writeTo(output);
                output.flush();
                output.close();
            }
            catch (Throwable t) {
                this.error.compareAndSet(null, t);
                throw (RuntimeException)ThrowableUtil.maskException(t);
            }
            finally {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        });
    }

    @Override
    public int read() throws IOException {
        NullUtil.checkError(this.error);
        return NullUtil.wrapInt(this.error, () -> super.read());
    }

    @Override
    public int read(byte[] b) throws IOException {
        NullUtil.checkError(this.error);
        return NullUtil.wrapInt(this.error, () -> super.read(b));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        NullUtil.checkError(this.error);
        return NullUtil.wrapInt(this.error, () -> super.read(b, off, len));
    }

    @Override
    public long skip(long n) throws IOException {
        NullUtil.checkError(this.error);
        return NullUtil.wrapLong(this.error, () -> super.skip(n));
    }

    @Override
    public int available() throws IOException {
        NullUtil.checkError(this.error);
        return NullUtil.wrapInt(this.error, () -> super.available());
    }

    @Override
    public void reset() throws IOException {
        NullUtil.checkError(this.error);
        NullUtil.wrap(this.error, () -> super.reset());
    }

    protected PipedStreams getPipedStreams() {
        return ((PipedStreams.Input)this.in).getPipedStreams();
    }
}

