/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.dellroad.stuff.io.NullUtil;
import org.dellroad.stuff.io.PipedStreams;
import org.dellroad.stuff.io.ReadCallback;
import org.dellroad.stuff.java.ThrowableUtil;

public class NullModemOutputStream
extends FilterOutputStream {
    private final AtomicReference<Throwable> error = new AtomicReference();
    private boolean synchronousClose;
    private boolean readerFinished;

    public NullModemOutputStream(ReadCallback reader, String threadName) {
        this(reader, NullUtil.newThreadExecutor(threadName));
    }

    public NullModemOutputStream(ReadCallback reader, Executor executor) {
        super(new PipedStreams().getOutputStream());
        if (reader == null) {
            throw new IllegalArgumentException("null reader");
        }
        if (executor == null) {
            throw new IllegalArgumentException("null executor");
        }
        PipedStreams.Input input = this.getPipedStreams().getInputStream();
        executor.execute(() -> {
            try {
                reader.readFrom(input);
            }
            catch (Throwable t) {
                this.error.compareAndSet(null, t);
                throw (RuntimeException)ThrowableUtil.maskException(t);
            }
            finally {
                NullModemOutputStream nullModemOutputStream = this;
                synchronized (nullModemOutputStream) {
                    this.readerFinished = true;
                    this.notifyAll();
                }
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        });
    }

    public boolean isSynchronousClose() {
        return this.synchronousClose;
    }

    public void setSynchronousClose(boolean synchronousClose) {
        this.synchronousClose = synchronousClose;
    }

    @Override
    public void write(int b) throws IOException {
        NullUtil.checkError(this.error);
        NullUtil.wrap(this.error, () -> super.write(b));
    }

    @Override
    public void write(byte[] b) throws IOException {
        NullUtil.checkError(this.error);
        NullUtil.wrap(this.error, () -> super.write(b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        NullUtil.checkError(this.error);
        NullUtil.wrap(this.error, () -> this.out.write(b, off, len));
    }

    @Override
    public void flush() throws IOException {
        NullUtil.checkError(this.error);
        NullUtil.wrap(this.error, () -> super.flush());
    }

    @Override
    public void close() throws IOException {
        this.error.set(null);
        super.close();
        if (this.synchronousClose) {
            try {
                this.waitForReader();
            }
            catch (InterruptedException e) {
                throw new IOException("interrupted while waiting for reader to finish", e);
            }
        }
    }

    protected synchronized void waitForReader() throws InterruptedException {
        while (!this.readerFinished) {
            this.wait();
        }
    }

    protected PipedStreams getPipedStreams() {
        return ((PipedStreams.Output)this.out).getPipedStreams();
    }
}

