/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

final class NullUtil {
    private NullUtil() {
    }

    public static void wrap(AtomicReference<Throwable> error, IO io) throws IOException {
        try {
            io.run();
        }
        catch (IOException e) {
            throw NullUtil.initCauseFromError(e, error);
        }
    }

    public static int wrapInt(AtomicReference<Throwable> error, IntIO io) throws IOException {
        try {
            return io.run();
        }
        catch (IOException e) {
            throw NullUtil.initCauseFromError(e, error);
        }
    }

    public static long wrapLong(AtomicReference<Throwable> error, LongIO io) throws IOException {
        try {
            return io.run();
        }
        catch (IOException e) {
            throw NullUtil.initCauseFromError(e, error);
        }
    }

    public static void checkError(AtomicReference<Throwable> error) throws IOException {
        Throwable e = error.get();
        if (e != null) {
            throw new IOException("exception thrown in callback", e);
        }
    }

    private static IOException initCauseFromError(IOException e, AtomicReference<Throwable> error) {
        Throwable cause = error.get();
        if (cause != null && e.getCause() == null) {
            e.initCause(cause);
        }
        return e;
    }

    public static Executor newThreadExecutor(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        return runnable -> {
            Thread thread = new Thread(runnable, name);
            thread.setDaemon(true);
            thread.start();
        };
    }

    @FunctionalInterface
    static interface LongIO {
        public long run() throws IOException;
    }

    @FunctionalInterface
    static interface IntIO {
        public int run() throws IOException;
    }

    @FunctionalInterface
    static interface IO {
        public void run() throws IOException;
    }
}

