/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.dellroad.stuff.io.RandomEscape;

public class OutputStreamWriter
extends FilterOutputStream {
    private final RandomEscape randomEscape = new RandomEscape();
    private int escape = this.randomEscape.next();
    private boolean started;
    private boolean closed;

    public OutputStreamWriter(OutputStream output) {
        super(output);
    }

    public synchronized void start() throws IOException {
        if (this.closed) {
            throw new IOException("this instance is closed");
        }
        if (this.started) {
            throw new IOException("already started");
        }
        this.started = true;
    }

    public synchronized void stop() throws IOException {
        if (this.closed) {
            throw new IOException("this instance is closed");
        }
        if (!this.started) {
            throw new IOException("not started");
        }
        this.started = false;
        this.writeControl(2);
        this.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.started) {
            this.started = false;
            this.writeControl(2);
        }
        this.closed = true;
        this.out.close();
    }

    @Override
    public synchronized void write(int ch) throws IOException {
        if (this.closed) {
            throw new IOException("this instance is closed");
        }
        if (!this.started) {
            this.started = true;
        }
        if ((ch & 0xFF) == this.escape) {
            this.writeControl(1);
            return;
        }
        this.out.write(ch);
    }

    private synchronized void writeControl(int control) throws IOException {
        this.out.write(this.escape);
        this.out.write(this.escape ^ control);
        this.escape = this.randomEscape.next();
    }
}

