/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class PipedStreams {
    public static final int DEFAULT_BUFFER_SIZE = 8160;
    private final Input input = new Input();
    private final Output output = new Output();
    private final byte[] buf;
    private int off;
    private int len;
    private boolean inputClosed;
    private boolean outputClosed;

    public PipedStreams() {
        this(8160);
    }

    public PipedStreams(int bufsiz) {
        if (bufsiz <= 0) {
            throw new IllegalArgumentException("bufsiz <= 0");
        }
        this.buf = new byte[bufsiz];
    }

    public Input getInputStream() {
        return this.input;
    }

    public Output getOutputStream() {
        return this.output;
    }

    private synchronized int read() throws IOException {
        assert (this.check());
        if (!this.waitForInput()) {
            return -1;
        }
        assert (this.len > 0);
        int b = this.buf[this.off] & 0xFF;
        this.off = (this.off + 1) % this.buf.length;
        --this.len;
        if (this.len + 1 == this.buf.length) {
            this.notifyAll();
        }
        return b;
    }

    private synchronized int read(byte[] b, int off, int len) throws IOException {
        int num;
        assert (this.check());
        if (off < 0 || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.inputClosed) {
            throw new IOException("input closed");
        }
        if (len == 0) {
            return 0;
        }
        if (!this.waitForInput()) {
            return -1;
        }
        assert (this.len > 0);
        int total = 0;
        for (int i = 0; i < 2 && (num = Math.min(len, Math.min(this.len, this.buf.length - this.off))) != 0; ++i) {
            System.arraycopy(this.buf, this.off, b, off, num);
            off += num;
            len -= num;
            this.off = (this.off + num) % this.buf.length;
            this.len -= num;
            total += num;
        }
        if (this.len + total == this.buf.length) {
            this.notifyAll();
        }
        return total;
    }

    private synchronized long skip(long n) throws IOException {
        assert (this.check());
        if (this.inputClosed) {
            throw new IOException("input closed");
        }
        if (n <= 0L) {
            return 0L;
        }
        int skip = (int)Math.min((long)this.len, n);
        this.off = (this.off + skip) % this.buf.length;
        this.len -= skip;
        if (this.len + skip == this.buf.length) {
            this.notifyAll();
        }
        return skip;
    }

    private synchronized int available() throws IOException {
        assert (this.check());
        if (this.inputClosed) {
            throw new IOException("input closed");
        }
        return this.len;
    }

    private synchronized void closeInput() {
        assert (this.check());
        if (!this.inputClosed) {
            this.inputClosed = true;
            this.notifyAll();
        }
    }

    private synchronized void write(int b) throws IOException {
        assert (this.check());
        this.waitForOutput();
        assert (this.len < this.buf.length);
        this.buf[(this.off + this.len) % this.buf.length] = (byte)b;
        ++this.len;
        if (this.len == 1) {
            this.notifyAll();
        }
    }

    private synchronized void write(byte[] b, int off, int len) throws IOException {
        assert (this.check());
        if (off < 0 || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.outputClosed) {
            throw new IOException("output closed");
        }
        while (len > 0) {
            this.waitForOutput();
            assert (this.len < this.buf.length);
            int soff = (this.off + this.len) % this.buf.length;
            int num = Math.min(len, (soff < this.off ? this.off : this.buf.length) - soff);
            System.arraycopy(b, off, this.buf, soff, num);
            off += num;
            len -= num;
            this.len += num;
            if (this.len != num) continue;
            this.notifyAll();
        }
    }

    private synchronized void closeOutput() {
        assert (this.check());
        if (!this.outputClosed) {
            this.outputClosed = true;
            this.notifyAll();
        }
    }

    private boolean waitForInput() throws IOException {
        assert (Thread.holdsLock(this));
        while (true) {
            assert (this.check());
            if (this.inputClosed) {
                throw new IOException("input closed");
            }
            if (this.len > 0) {
                return true;
            }
            if (this.outputClosed) {
                return false;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
        }
    }

    private void waitForOutput() throws IOException {
        assert (Thread.holdsLock(this));
        while (true) {
            assert (this.check());
            if (this.outputClosed) {
                throw new IOException("output closed");
            }
            if (this.inputClosed) {
                throw new IOException("input closed");
            }
            if (this.len < this.buf.length) {
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
        }
    }

    private boolean check() {
        assert (this.buf.length > 0);
        assert (this.off >= 0);
        assert (this.off < this.buf.length);
        assert (this.len >= 0);
        assert (this.len <= this.buf.length);
        return true;
    }

    public static interface HasPipedStreams {
        public PipedStreams getPipedStreams();
    }

    public final class Output
    extends OutputStream
    implements HasPipedStreams {
        private Output() {
        }

        @Override
        public PipedStreams getPipedStreams() {
            return PipedStreams.this;
        }

        @Override
        public void write(int b) throws IOException {
            PipedStreams.this.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            PipedStreams.this.write(b, off, len);
        }

        @Override
        public void close() {
            PipedStreams.this.closeOutput();
        }
    }

    public final class Input
    extends InputStream
    implements HasPipedStreams {
        private Input() {
        }

        @Override
        public PipedStreams getPipedStreams() {
            return PipedStreams.this;
        }

        @Override
        public int read() throws IOException {
            return PipedStreams.this.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return PipedStreams.this.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return PipedStreams.this.skip(n);
        }

        @Override
        public int available() throws IOException {
            return PipedStreams.this.available();
        }

        @Override
        public void close() {
            PipedStreams.this.closeInput();
        }
    }
}

