/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.dellroad.stuff.java.Primitive;
import org.dellroad.stuff.java.ReflectUtil;

public final class AnnotationUtil {
    private AnnotationUtil() {
    }

    public static List<Annotation> getAnnotations(Class<?> methodClass, String methodName, Class<?> ... methodParameterTypes) {
        Method method;
        if (methodClass == null) {
            throw new IllegalArgumentException("null methodClass");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("null methodName");
        }
        if (methodParameterTypes == null) {
            throw new IllegalArgumentException("null methodParameterTypes");
        }
        try {
            method = methodClass.getDeclaredMethod(methodName, methodParameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("method " + methodClass.getName() + "." + methodName + "() not found");
        }
        try {
            return Arrays.asList(method.getDeclaredAnnotations());
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected exception", e);
        }
    }

    public static <A extends Annotation> A getAnnotation(Class<A> annotationType, Class<?> methodClass, String methodName, Class<?> ... methodParameterTypes) {
        if (annotationType == null) {
            throw new IllegalArgumentException("null annotationType");
        }
        return (A)AnnotationUtil.getAnnotations(methodClass, methodName, methodParameterTypes).stream().filter(annotationType::isInstance).map(annotationType::cast).findFirst().orElseThrow(() -> new RuntimeException("didn't find " + annotationType + " on " + methodName + "()"));
    }

    public static <A extends Annotation> void applyAnnotationValues(Object bean, String methodPrefix, A annotation, A defaults, BiFunction<? super List<Method>, String, String> propertyFinder, Function<? super Class<?>, ?> instantiator) {
        if (bean == null) {
            throw new IllegalArgumentException("null bean");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("null annotation");
        }
        if (propertyFinder == null) {
            throw new IllegalArgumentException("null propertyFinder");
        }
        ReflectUtil.findPropertySetters(bean.getClass(), methodPrefix).forEach((propertyName, methodList) -> {
            List<Object> value;
            Method annotationGetter;
            String annotationPropertyName = (String)propertyFinder.apply((List<Method>)methodList, (String)propertyName);
            if (annotationPropertyName == null) {
                return;
            }
            try {
                annotationGetter = annotation.getClass().getMethod(annotationPropertyName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return;
            }
            try {
                value = annotationGetter.invoke((Object)annotation, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("error reading annotation property \"" + annotationPropertyName + "\"", e);
            }
            if (defaults != null) {
                Object defaultValue;
                try {
                    defaultValue = annotationGetter.invoke((Object)defaults, new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("error reading annotation property \"" + annotationPropertyName + "\"", e);
                }
                if (Objects.deepEquals(value, defaultValue)) {
                    return;
                }
            }
            if (value instanceof Class) {
                value = instantiator.apply((Class)((Object)value));
            }
            Method failTarget = null;
            Exception lastException = null;
            Iterator iterator = methodList.iterator();
            while (iterator.hasNext()) {
                Method beanSetter;
                failTarget = beanSetter = (Method)iterator.next();
                Class<?> parameterType = Primitive.wrap(beanSetter.getParameterTypes()[0]);
                if (value instanceof Object[] && List.class.isAssignableFrom(parameterType)) {
                    value = Arrays.asList((Object[])value);
                }
                if (!parameterType.isInstance(value)) continue;
                if ((beanSetter.getModifiers() & 1) != 0) {
                    try {
                        beanSetter.setAccessible(true);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                try {
                    beanSetter.invoke(bean, value);
                }
                catch (ReflectiveOperationException | UnsupportedOperationException e) {
                    lastException = e;
                    continue;
                }
                lastException = null;
                break;
            }
            if (lastException != null) {
                throw new RuntimeException("error applying annotation property \"" + annotationPropertyName + "\" to " + failTarget, lastException);
            }
        });
    }
}

